/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.dubbo.graceclose;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.LoggerContext;
import cn.com.duibaboot.ext.autoconfigure.core.EarlyClose;
import java.lang.reflect.Field;
import org.apache.dubbo.config.DubboShutdownHook;
import org.apache.dubbo.config.deploy.DefaultApplicationDeployer;
import org.apache.dubbo.config.spring.util.DubboBeanUtils;
import org.apache.dubbo.rpc.model.ScopeModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class DubboGracefulCloseAutoConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(DubboGracefulCloseAutoConfiguration.class);

    @Bean
    public DubboGracefulCloseLifeCycle dubboGracefulCloseLifeCycle() {
        return new DubboGracefulCloseLifeCycle();
    }

    public static class DubboGracefulCloseLifeCycle
    extends EarlyClose {
        @Autowired
        private ApplicationContext applicationContext;

        public void stop() {
            if (!logger.isInfoEnabled()) {
                LoggerContext loggerContext = (LoggerContext)LoggerFactory.getILoggerFactory();
                loggerContext.getLogger(DubboGracefulCloseAutoConfiguration.class).setLevel(Level.INFO);
            }
            try {
                logger.info("clean up dubbo");
                Field field = DefaultApplicationDeployer.class.getDeclaredField("dubboShutdownHook");
                field.setAccessible(true);
                DefaultApplicationDeployer defaultApplicationDeployer = (DefaultApplicationDeployer)DefaultApplicationDeployer.get((ScopeModel)DubboBeanUtils.getModuleModel((BeanFactory)this.applicationContext));
                DubboShutdownHook hook = (DubboShutdownHook)field.get(defaultApplicationDeployer);
                hook.run();
            }
            catch (ExceptionInInitializerError field) {
            }
            catch (Throwable e) {
                logger.error(e.getMessage(), e);
            }
        }

        public int getPhase() {
            return -2;
        }
    }
}

