/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.dubbo.hystrix;

import cn.com.duiba.boot.event.MainContextRefreshedEvent;
import cn.com.duibaboot.ext.autoconfigure.cloud.netflix.feign.hystrix.HystrixFeignConfiguration;
import com.netflix.hystrix.HystrixCommand;
import feign.hystrix.HystrixFeign;
import java.lang.reflect.Method;
import java.util.Collection;
import org.apache.dubbo.config.annotation.DubboService;
import org.apache.dubbo.rpc.model.ApplicationModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.cloud.openfeign.CustomFeignClientsRegistrar;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.event.EventListener;

@Configuration
@ConditionalOnClass(value={HystrixCommand.class, HystrixFeign.class})
public class DubboHystrixFeignConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(DubboHystrixFeignConfiguration.class);

    @Configuration
    @ConditionalOnClass(value={DubboService.class, ApplicationModel.class})
    public static class DubboHystrixInfoConfiguration {
        @Value(value="${spring.application.name}")
        private String springApplicationName;

        @EventListener(value={MainContextRefreshedEvent.class})
        public void initDubboHystrixInfo() {
            Collection consumerModels = ApplicationModel.allConsumerModels();
            if (consumerModels.isEmpty()) {
                return;
            }
            consumerModels.forEach(consumerModel -> {
                Class interfaceClass = consumerModel.getServiceInterfaceClass();
                String name = null;
                try {
                    name = CustomFeignClientsRegistrar.searchAndSetClientNameFromPackageInfo((String)interfaceClass.getPackage().getName());
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
                if (name == null) {
                    logger.warn("\u5efa\u8bae\u5728{}\u7c7b\u6240\u5728\u5305\u4e0a\u6807\u6ce8@AdvancedFeignClient\uff0c\u5e26\u4e0a\u5e94\u7528\u540d\uff0c\u4ee5\u652f\u6301\u5728\u754c\u9762\u4e0a\u914d\u7f6e\u63a5\u53e3\u8d85\u65f6\u65f6\u95f4\u3002");
                    return;
                }
                for (Method method : interfaceClass.getDeclaredMethods()) {
                    if (method.isDefault()) continue;
                    HystrixFeignConfiguration.create((String)this.springApplicationName, (String)name, (Class)interfaceClass, (Method)method);
                }
            });
        }
    }
}

