/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.dubbo.cat;

import cn.com.duibaboot.ext.autoconfigure.cat.CatAutoConfiguration;
import cn.com.duibaboot.ext.autoconfigure.cat.CatProperties;
import cn.com.duibaboot.ext.autoconfigure.cat.SpringMvcConfigForCat;
import com.dianping.cat.servlet.CatFilter;
import com.dianping.cat.status.StatusExtension;
import com.dianping.cat.status.StatusExtensionRegister;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ThreadPoolExecutor;
import javax.annotation.PostConstruct;
import org.apache.dubbo.common.constants.CommonConstants;
import org.apache.dubbo.common.extension.ExtensionLoader;
import org.apache.dubbo.common.threadpool.manager.DefaultExecutorRepository;
import org.apache.dubbo.common.threadpool.manager.ExecutorRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.EnableAspectJAutoProxy;
import org.springframework.context.annotation.Import;

@Configuration
@EnableAspectJAutoProxy(proxyTargetClass=true)
@Import(value={SpringMvcConfigForCat.class})
@EnableConfigurationProperties(value={CatProperties.class})
public class DubboCatAutoConfiguration {
    private static final String ThreadPoolWaterLevelId = "\u7ebf\u7a0b\u6c60\u6c34\u4f4d\u56fe";

    @Configuration
    @Conditional(value={CatAutoConfiguration.CatCondition.class})
    @ConditionalOnClass(value={CatFilter.class})
    public static class DubboThreadPoolWaterLevelHeartbeatExtenstion
    implements StatusExtension {
        private static final Logger log = LoggerFactory.getLogger(DubboThreadPoolWaterLevelHeartbeatExtenstion.class);

        public String getId() {
            return DubboCatAutoConfiguration.ThreadPoolWaterLevelId;
        }

        public String getDescription() {
            return "\u5404\u4e2a\u7ebf\u7a0b\u6c60\u7684\u6c34\u4f4d\u76d1\u63a7\u5fc3\u8df3";
        }

        public Map<String, String> getProperties() {
            HashMap<String, String> maps = new HashMap<String, String>();
            ExecutorRepository executorRepository = (ExecutorRepository)ExtensionLoader.getExtensionLoader(ExecutorRepository.class).getDefaultExtension();
            if (executorRepository instanceof DefaultExecutorRepository) {
                DefaultExecutorRepository defaultExecutorRepository = (DefaultExecutorRepository)executorRepository;
                try {
                    Field field = DefaultExecutorRepository.class.getDeclaredField("data");
                    field.setAccessible(true);
                    ConcurrentMap data = (ConcurrentMap)field.get(defaultExecutorRepository);
                    ConcurrentMap executors = (ConcurrentMap)data.get(CommonConstants.EXECUTOR_SERVICE_COMPONENT_KEY);
                    if (executors != null) {
                        executors.forEach((port, executor) -> {
                            if (executor != null && executor instanceof ThreadPoolExecutor) {
                                ThreadPoolExecutor tp = (ThreadPoolExecutor)executor;
                                String portStr = executors.size() == 1 ? "" : "port:" + port + ",";
                                maps.put("Dubbo-ActiveCount(" + portStr + "core:" + tp.getCorePoolSize() + ",max:" + tp.getMaximumPoolSize() + ")", String.valueOf(tp.getActiveCount()));
                            }
                        });
                    }
                    return maps;
                }
                catch (IllegalAccessException | NoSuchFieldException e) {
                    log.warn("dubbo\u7ebf\u7a0b\u6c60\u5fc3\u8df3\u76d1\u63a7\u5f02\u5e38, ", (Throwable)e);
                }
            }
            return maps;
        }

        @PostConstruct
        public void initialize() {
            StatusExtensionRegister.getInstance().register((StatusExtension)this);
        }
    }
}

