/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.dubbo.init;

import cn.com.duibaboot.ext.autoconfigure.dubbo.core.DubboSpecifiedBeanPostProcessor;
import cn.com.duibaboot.ext.autoconfigure.dubbo.deploy.DeployBeanDefinitionRegistryPostProcessor;
import cn.com.duibaboot.ext.autoconfigure.dubbo.init.DubboBeanPostProcessorOfSpecified;
import cn.com.duibaboot.ext.autoconfigure.dubbo.init.DubboBootstrapListenerForAsyncSpecified;
import org.apache.dubbo.rpc.service.EchoService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfigureOrder;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@AutoConfigureOrder(value=-2147483648)
public class InitDubboServerAutoConfiguration {
    private static Logger logger = LoggerFactory.getLogger(InitDubboServerAutoConfiguration.class);

    @Bean
    public static DeployBeanDefinitionRegistryPostProcessor deployBeanDefinitionRegistryPostProcessor() {
        return new DeployBeanDefinitionRegistryPostProcessor();
    }

    @Bean
    public static DubboBeanPostProcessorOfSpecified dubboBeanPostProcessorOfSpecified() {
        return new DubboBeanPostProcessorOfSpecified();
    }

    @Bean
    public DubboBootstrapListenerForAsyncSpecified dubboBootstrapListenerForAsyncSpecified(DubboBeanPostProcessorOfSpecified dubboBeanPostProcessorOfSpecified) {
        return new DubboBootstrapListenerForAsyncSpecified(dubboBeanPostProcessorOfSpecified.getDubboAsyncProcessor2BeansMap());
    }

    @Configuration
    public static class DubboPostProcessorConfiguration {
        @Bean
        public DubboSpecifiedBeanPostProcessor dubboPostProcessorConfigurer() {
            return new DubboSpecifiedBeanPostProcessor<EchoService>(){

                public Class<EchoService> getBeanType() {
                    return EchoService.class;
                }

                public void postProcessAfterInitialization(EchoService echoService, String beanName) {
                    try {
                        echoService.$echo((Object)"OK");
                    }
                    catch (Exception e) {
                        logger.error(e.getMessage(), (Throwable)e);
                    }
                }
            };
        }
    }
}

