package cn.com.duibaboot.ext.autoconfigure.dubbo.cat;

import cn.com.duibaboot.ext.autoconfigure.cat.CatAutoConfiguration;
import cn.com.duibaboot.ext.autoconfigure.cat.CatProperties;
import cn.com.duibaboot.ext.autoconfigure.cat.SpringMvcConfigForCat;
import cn.com.duiba.cat.servlet.CatFilter;
import cn.com.duiba.cat.status.StatusExtension;
import cn.com.duiba.cat.status.StatusExtensionRegister;
import org.apache.dubbo.common.constants.CommonConstants;
import org.apache.dubbo.common.extension.ExtensionLoader;
import org.apache.dubbo.common.threadpool.manager.DefaultExecutorRepository;
import org.apache.dubbo.common.threadpool.manager.ExecutorRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.EnableAspectJAutoProxy;
import org.springframework.context.annotation.Import;

import javax.annotation.PostConstruct;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadPoolExecutor;

/**
 * Created by wenqi.huang on 2016/11/7.
 */
@Configuration
@EnableAspectJAutoProxy(proxyTargetClass = true)
@Import(SpringMvcConfigForCat.class)
@EnableConfigurationProperties(CatProperties.class)
public class DubboCatAutoConfiguration {
    private static final String ThreadPoolWaterLevelId = "线程池水位图";

    /**
     * 监控dubbo线程池使用情况，给cat发送心跳来记录
     */
    @Configuration
    @Conditional(CatAutoConfiguration.CatCondition.class)
    @ConditionalOnClass({CatFilter.class})
    public static class DubboThreadPoolWaterLevelHeartbeatExtenstion implements StatusExtension {

        private static final Logger log = LoggerFactory.getLogger(DubboThreadPoolWaterLevelHeartbeatExtenstion.class);

        //给当前的类定义一个extension id, cat服务端会将一个extension id作为一个group，然后将每个key指标都会做图形处理，结果会在cat的heartbeat中进行展示
        @Override
        public String getId() {
            return ThreadPoolWaterLevelId;
        }

        //一个简单描述
        @Override
        public String getDescription() {
            return "各个线程池的水位监控心跳";
        }

        //每隔一分钟自动被cat调用一次
        @Override
        public Map<String, String> getProperties() {
            Map<String, String> maps = new HashMap<>();

            ExecutorRepository executorRepository = ExtensionLoader.getExtensionLoader(ExecutorRepository.class).getDefaultExtension();

            if (executorRepository instanceof DefaultExecutorRepository) {
                DefaultExecutorRepository defaultExecutorRepository = (DefaultExecutorRepository) executorRepository;
                try {
                    Field field = DefaultExecutorRepository.class.getDeclaredField("data");
                    field.setAccessible(true);
                    ConcurrentMap<String, ConcurrentMap<Integer, ExecutorService>> data = (ConcurrentMap<String, ConcurrentMap<Integer, ExecutorService>>) field.get(defaultExecutorRepository);

                    // 针对provider
                    ConcurrentMap<Integer, ExecutorService> executors = data.get(CommonConstants.EXECUTOR_SERVICE_COMPONENT_KEY);
                    if (executors != null) {
                        executors.forEach((port, executor) -> {
                            if (executor != null && executor instanceof ThreadPoolExecutor) {
                                ThreadPoolExecutor tp = (ThreadPoolExecutor) executor;

                                //这里的每个key指标都会做图形处理，结果会在cat的heartbeat中进行展示,注意，只有value值可以被转化double类型的才会在heartbeat做图形展示
                                String portStr = executors.size() == 1 ? "" : ("port:" + port) + ",";
                                maps.put("Dubbo-ActiveCount(" + portStr + "core:" + tp.getCorePoolSize() + ",max:" + tp.getMaximumPoolSize() + ")", String.valueOf(tp.getActiveCount()));
                            }
                        });
                    }
                    return maps;

                } catch (NoSuchFieldException | IllegalAccessException e) {
                    // do nothing
                    log.warn("dubbo线程池心跳监控异常, ", e);
                }
            }

            return maps;
        }

        //这里是实现了初始化方法，把这个实现注册到cat上，如果你使用spring，需要在spring里面注册此bean，并实现初始化方法。
        @PostConstruct
        public void initialize() {
            StatusExtensionRegister.getInstance().register(this);
        }

    }

}
