/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.dubbo.loadbalance;

import java.util.List;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.cluster.LoadBalance;

public abstract class AbstractSmoothWarmUpLoadBalance
implements LoadBalance {
    static int calculateWarmupWeight(int uptime, int warmup, int weight) {
        int ww = (int)Math.pow(weight, (double)uptime / (double)warmup);
        if (ww < 1) {
            return 1;
        }
        return Math.min(ww, weight);
    }

    public <T> Invoker<T> select(List<Invoker<T>> invokers, URL url, Invocation invocation) {
        if (CollectionUtils.isEmpty(invokers)) {
            return null;
        }
        if (invokers.size() == 1) {
            return invokers.get(0);
        }
        return this.doSelect(invokers, url, invocation);
    }

    protected abstract <T> Invoker<T> doSelect(List<Invoker<T>> var1, URL var2, Invocation var3);

    int getWeight(Invoker<?> invoker, Invocation invocation) {
        long timestamp;
        int weight = invoker.getUrl().getMethodParameter(invocation.getMethodName(), "weight", 100);
        if (weight > 0 && (timestamp = invoker.getUrl().getParameter("timestamp", 0L)) > 0L) {
            long uptime = System.currentTimeMillis() - timestamp;
            if (uptime < 0L) {
                return 1;
            }
            int warmup = invoker.getUrl().getParameter("warmup", 600000);
            if (uptime > 0L && uptime < (long)warmup) {
                weight = AbstractSmoothWarmUpLoadBalance.calculateWarmupWeight((int)uptime, warmup, weight);
            }
        }
        return Math.max(weight, 0);
    }
}

