/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.dubbo.group;

import cn.com.duiba.boot.grouping.ServiceGroupUtils;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.RpcException;
import org.apache.dubbo.rpc.cluster.router.AbstractRouter;

public class ServiceGroupDubboRouter
extends AbstractRouter {
    public ServiceGroupDubboRouter(URL url) {
        this.setUrl(url);
    }

    public <T> List<Invoker<T>> route(List<Invoker<T>> invokers, URL url, Invocation invocation) throws RpcException {
        if (CollectionUtils.isEmpty(invokers)) {
            return invokers;
        }
        String currentServiceGroupKey = ServiceGroupUtils.getCurrentGroupKey();
        ArrayList<Invoker<T>> havePriorityList = new ArrayList<Invoker<T>>(invokers.size());
        ArrayList<Invoker<T>> noGroupKeyInvokerList = new ArrayList<Invoker<T>>(invokers.size());
        for (Invoker<T> invoker : invokers) {
            String invokerGroupKey = invoker.getUrl().getParameter("serviceGroupKey");
            if (this.isPriorityGroup(currentServiceGroupKey, invokerGroupKey)) {
                havePriorityList.add(invoker);
            }
            if (!this.isNoGroup(invokerGroupKey)) continue;
            noGroupKeyInvokerList.add(invoker);
        }
        if (!havePriorityList.isEmpty()) {
            return havePriorityList;
        }
        if (!noGroupKeyInvokerList.isEmpty()) {
            return noGroupKeyInvokerList;
        }
        return invokers;
    }

    private boolean isPriorityGroup(String requestGroupKey, String serverGroupKey) {
        if (StringUtils.isBlank((CharSequence)requestGroupKey) || StringUtils.isBlank((CharSequence)serverGroupKey)) {
            return false;
        }
        return StringUtils.equals((CharSequence)requestGroupKey, (CharSequence)serverGroupKey);
    }

    private boolean isNoGroup(String serverGroupKey) {
        return StringUtils.isBlank((CharSequence)serverGroupKey);
    }
}

