/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.dubbo.sleuth;

import brave.ErrorParser;
import brave.Span;
import brave.SpanCustomizer;
import brave.Tracer;
import brave.Tracing;
import brave.propagation.TraceContext;
import brave.propagation.TraceContextOrSamplingFlags;
import cn.com.duiba.boot.utils.MainApplicationContextHolder;
import java.util.concurrent.Future;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.extension.Activate;
import org.apache.dubbo.rpc.Filter;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.Result;
import org.apache.dubbo.rpc.RpcContext;
import org.apache.dubbo.rpc.RpcException;
import org.apache.dubbo.rpc.protocol.dubbo.FutureAdapter;
import org.apache.dubbo.rpc.support.RpcUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

@Activate(group={"provider", "consumer"}, order=1)
public class SleuthDubboFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(SleuthDubboFilter.class);
    private static volatile Tracer tracer;
    private static volatile Tracing tracing;
    private static volatile ErrorParser errorParser;
    private static volatile TraceContext.Injector<DubboRequestTextMap> injector;
    private static volatile TraceContext.Extractor<DubboRequestTextMap> extractor;

    private static Tracer getTracer() {
        if (tracer == null && MainApplicationContextHolder.getApplicationContext() != null) {
            tracer = (Tracer)MainApplicationContextHolder.getApplicationContext().getBean(Tracer.class);
        }
        return tracer;
    }

    private static Tracing getTracing() {
        if (tracing == null && MainApplicationContextHolder.getApplicationContext() != null) {
            tracing = (Tracing)MainApplicationContextHolder.getApplicationContext().getBean(Tracing.class);
        }
        return tracing;
    }

    private static ErrorParser getErrorParser() {
        if (errorParser == null && MainApplicationContextHolder.getApplicationContext() != null) {
            errorParser = (ErrorParser)MainApplicationContextHolder.getApplicationContext().getBean(ErrorParser.class);
        }
        return errorParser;
    }

    private static TraceContext.Injector<DubboRequestTextMap> getInjector() {
        if (injector == null && SleuthDubboFilter.getTracing() != null) {
            injector = SleuthDubboFilter.getTracing().propagation().injector((carrier, key, value) -> carrier.put((String)key, value));
        }
        return injector;
    }

    private static TraceContext.Extractor<DubboRequestTextMap> getExtractor() {
        if (extractor == null && SleuthDubboFilter.getTracing() != null) {
            extractor = SleuthDubboFilter.getTracing().propagation().extractor((carrier, key) -> carrier.get((String)key));
        }
        return extractor;
    }

    public Result invoke(Invoker<?> invoker, Invocation invocation) throws RpcException {
        if (SleuthDubboFilter.getTracer() == null) {
            return invoker.invoke(invocation);
        }
        RpcContext rpcContext = RpcContext.getContext();
        URL url = invoker.getUrl();
        String sideKey = url.getParameter("side");
        String spanName = "dubbo:/" + invoker.getInterface().getSimpleName() + "/" + invocation.getMethodName();
        if ("consumer".equals(sideKey)) {
            Span span = SleuthDubboFilter.getTracer().nextSpan().name(spanName).kind(Span.Kind.CLIENT).start();
            try {
                Result result;
                block32: {
                    Tracer.SpanInScope scope = tracer.withSpanInScope(span);
                    try {
                        Result result2;
                        SleuthDubboFilter.getInjector().inject(span.context(), (Object)new DubboRequestTextMap(RpcContext.getContext()));
                        if (!span.isNoop()) {
                            span.tag("lc", "dubbo");
                            span.tag("peer.host", RpcContext.getContext().getRemoteHost() + ":" + RpcContext.getContext().getRemotePort());
                            span.tag("dubbo.invokeMethod", invoker.getInterface().getSimpleName() + "." + invocation.getMethodName());
                            span.tag("client.thread", Thread.currentThread().getName());
                        }
                        if ((result2 = invoker.invoke(invocation)).hasException()) {
                            SleuthDubboFilter.getErrorParser().error(result2.getException(), (SpanCustomizer)span);
                        }
                        result = result2;
                        if (scope == null) break block32;
                    }
                    catch (Throwable result2) {
                        try {
                            if (scope != null) {
                                try {
                                    scope.close();
                                }
                                catch (Throwable throwable) {
                                    result2.addSuppressed(throwable);
                                }
                            }
                            throw result2;
                        }
                        catch (Exception e) {
                            SleuthDubboFilter.getErrorParser().error((Throwable)e, (SpanCustomizer)span);
                            throw e;
                        }
                    }
                    scope.close();
                }
                return result;
            }
            finally {
                span.finish();
            }
        }
        TraceContextOrSamplingFlags extracted = SleuthDubboFilter.getExtractor().extract((Object)new DubboRequestTextMap(RpcContext.getContext()));
        Span span = (extracted.context() != null ? SleuthDubboFilter.getTracer().joinSpan(extracted.context()) : SleuthDubboFilter.getTracer().nextSpan(extracted)).name(spanName).kind(Span.Kind.SERVER).start();
        boolean isOneway = false;
        boolean deferFinish = false;
        try {
            Result result;
            block33: {
                Tracer.SpanInScope scope = tracer.withSpanInScope(span);
                try {
                    Result result3;
                    if (!span.isNoop()) {
                        span.tag("lc", "dubbo");
                        span.tag("server.thread", Thread.currentThread().getName());
                    }
                    if ((result3 = invoker.invoke(invocation)).hasException()) {
                        SleuthDubboFilter.onError(result3.getException(), span);
                    }
                    isOneway = RpcUtils.isOneway((URL)invoker.getUrl(), (Invocation)invocation);
                    Future future = rpcContext.getFuture();
                    if (!isOneway && future instanceof FutureAdapter) {
                        deferFinish = true;
                        ((FutureAdapter)future).whenComplete((v, t) -> {
                            if (t != null) {
                                SleuthDubboFilter.onError(t, span);
                                span.finish();
                            } else {
                                span.finish();
                            }
                        });
                    }
                    result = result3;
                    if (scope == null) break block33;
                }
                catch (Throwable throwable) {
                    try {
                        if (scope != null) {
                            try {
                                scope.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception e) {
                        SleuthDubboFilter.getErrorParser().error((Throwable)e, (SpanCustomizer)span);
                        throw e;
                    }
                }
                scope.close();
            }
            return result;
        }
        finally {
            if (isOneway) {
                span.flush();
            } else if (!deferFinish) {
                span.finish();
            }
        }
    }

    static void onError(Throwable error, Span span) {
        span.error(error);
        if (error instanceof RpcException) {
            span.tag("dubbo.error_code", Integer.toString(((RpcException)error).getCode()));
        }
    }

    static class DubboRequestTextMap {
        private final RpcContext delegate;

        DubboRequestTextMap(RpcContext delegate) {
            this.delegate = delegate;
        }

        public String get(String key) {
            return (String)this.delegate.getAttachments().get(key);
        }

        public void put(String key, String value) {
            if (!StringUtils.hasText((String)value)) {
                return;
            }
            this.delegate.setAttachment(key, value);
        }
    }
}

