/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.hazelcast.eureka;

import ch.qos.logback.classic.Level;
import cn.com.duiba.boot.utils.NetUtils;
import cn.com.duiba.wolf.utils.NumberUtils;
import cn.com.duibaboot.ext.autoconfigure.cloud.netflix.eureka.EurekaClientUtils;
import cn.com.duibaboot.ext.autoconfigure.hazelcast.DuibaHazelcastProperties;
import cn.com.duibaboot.ext.autoconfigure.hazelcast.eureka.EurekaHazelcastDiscoveryRegister;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.hazelcast.cluster.Address;
import com.hazelcast.logging.ILogger;
import com.hazelcast.spi.discovery.AbstractDiscoveryStrategy;
import com.hazelcast.spi.discovery.DiscoveryNode;
import com.hazelcast.spi.discovery.SimpleDiscoveryNode;
import com.netflix.appinfo.ApplicationInfoManager;
import com.netflix.appinfo.InstanceInfo;
import com.netflix.discovery.EurekaClient;
import com.netflix.discovery.shared.Application;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class EurekaOneDiscoveryStrategy
extends AbstractDiscoveryStrategy {
    private static final Logger log = LoggerFactory.getLogger(EurekaOneDiscoveryStrategy.class);
    private static final Set<InstanceInfo.InstanceStatus> ENABLE_SET;
    private static final int NUM_RETRIES = 5;
    private static final int VERIFICATION_WAIT_TIMEOUT = 1;
    private static final int DISCOVERY_RETRY_TIMEOUT = 3;
    private static final String HAZALCAST_NODE_APP_NAME = "hazalcast.discovery.app-name";
    private final AtomicBoolean running = new AtomicBoolean(true);
    private EurekaClient eurekaClient;
    private ApplicationInfoManager applicationInfoManager;
    private DiscoveryNode currentDiscoveryNode;
    private DuibaHazelcastProperties duibaHazelcastProperties;

    protected EurekaOneDiscoveryStrategy(ILogger logger, Map<String, Comparable> properties) {
        super(logger, properties);
    }

    public void setEurekaClient(EurekaClient eurekaClient) {
        this.eurekaClient = eurekaClient;
        this.applicationInfoManager = eurekaClient.getApplicationInfoManager();
    }

    public void setDuibaHazelcastProperties(DuibaHazelcastProperties duibaHazelcastProperties) {
        this.duibaHazelcastProperties = duibaHazelcastProperties;
    }

    public void setCurrentDiscoveryNode(DiscoveryNode currentDiscoveryNode) {
        this.currentDiscoveryNode = currentDiscoveryNode;
    }

    private boolean isMember() {
        return this.currentDiscoveryNode != null;
    }

    private String getApplicationName() {
        String appName = this.duibaHazelcastProperties.getProperties().get(HAZALCAST_NODE_APP_NAME);
        if (StringUtils.isNotBlank((String)appName)) {
            return appName;
        }
        return this.applicationInfoManager.getEurekaInstanceConfig().getAppname();
    }

    public void start() {
        block2: while (this.running.get()) {
            try {
                EurekaClientUtils.refreshRegistry((EurekaClient)this.eurekaClient);
                Application application = this.eurekaClient.getApplication(this.getApplicationName());
                if (application == null) {
                    this.waitingRegistration();
                    continue;
                }
                if (!this.isMember()) break;
                String address = NetUtils.getLocalIp();
                List instances = application.getInstancesAsIsFromEureka();
                for (InstanceInfo info : instances) {
                    if (!StringUtils.equals((String)address, (String)info.getIPAddr()) || !ENABLE_SET.contains(info.getStatus())) continue;
                    break block2;
                }
                this.waitingRegistration();
            }
            catch (Throwable t) {
                if (t instanceof Error) {
                    throw (Error)t;
                }
                log.error("", t);
            }
        }
    }

    private void waitingRegistration() {
        try {
            this.getLogger().info("Waiting for registration with Eureka...");
            TimeUnit.SECONDS.sleep(1L);
        }
        catch (InterruptedException almostIgnore) {
            this.running.set(false);
            Thread.currentThread().interrupt();
        }
    }

    public Iterable<DiscoveryNode> discoverNodes() {
        ArrayList nodes = Lists.newArrayList();
        String applicationName = this.getApplicationName();
        Application application = null;
        for (int i = 0; i < 5; ++i) {
            EurekaClientUtils.refreshRegistry((EurekaClient)this.eurekaClient);
            application = this.eurekaClient.getApplication(applicationName);
            if (application != null) break;
            try {
                TimeUnit.SECONDS.sleep(3L);
                continue;
            }
            catch (InterruptedException almostIgnore) {
                Thread.currentThread().interrupt();
            }
        }
        if (Objects.isNull(application)) {
            log.warn("Don't find hazelcast nodes");
            return nodes;
        }
        List instances = application.getInstancesAsIsFromEureka();
        for (InstanceInfo instance : instances) {
            int port;
            InetAddress address;
            if (instance.getStatus() != InstanceInfo.InstanceStatus.UP && instance.getStatus() != InstanceInfo.InstanceStatus.STARTING || null == (address = this.mapAddress(instance))) continue;
            Map metadata = instance.getMetadata();
            String portStr = (String)metadata.get("hazelcast.port");
            String version = (String)metadata.get("hazelcast.version");
            if (!StringUtils.equals((String)version, (String)EurekaHazelcastDiscoveryRegister.getHazelcastVersion()) || (port = NumberUtils.parseInt((String)portStr, (int)-1)) == -1) continue;
            nodes.add(new SimpleDiscoveryNode(new Address(address, port), metadata));
        }
        log.debug("hazelcast found nodes {}", nodes.stream().map(DiscoveryNode::getPrivateAddress).collect(Collectors.toList()));
        return nodes;
    }

    public void destroy() {
        this.running.set(false);
    }

    private InetAddress mapAddress(InstanceInfo instance) {
        try {
            return InetAddress.getByName(instance.getIPAddr());
        }
        catch (UnknownHostException e) {
            this.getLogger().warning("InstanceInfo '" + instance + "' could not be resolved");
            return null;
        }
    }

    static {
        ((ch.qos.logback.classic.Logger)log).setLevel(Level.INFO);
        ENABLE_SET = ImmutableSet.of((Object)InstanceInfo.InstanceStatus.UP, (Object)InstanceInfo.InstanceStatus.STARTING);
    }
}

