package cn.com.duibaboot.ext.autoconfigure.hazelcast.eureka;

import cn.com.duibaboot.ext.autoconfigure.hazelcast.DuibaHazelcastProperties;
import com.netflix.discovery.EurekaClient;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.client.ConditionalOnDiscoveryEnabled;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

/**
 * @author liuyao
 */
@Configuration
@ConditionalOnProperty(value = "eureka.client.enabled", matchIfMissing = true)
@ConditionalOnDiscoveryEnabled
@ConditionalOnClass(EurekaClient.class)
public class EurekaHazelcastDiscoveryConfiguration {

    @Bean
    public EurekaHazelcastDiscoveryRegister eurekaHazelcastDiscoveryRegister(){
        return new EurekaHazelcastDiscoveryRegister();
    }

    @Bean
    public EurekaOneDiscoveryStrategyFactory eurekaOneDiscoveryStrategyFactory(){
        return new EurekaOneDiscoveryStrategyFactory();
    }
}
