package cn.com.duibaboot.ext.autoconfigure.hazelcast.eureka;

import cn.com.duibaboot.ext.autoconfigure.cloud.netflix.eureka.DiscoveryMetadataRegister;
import cn.com.duibaboot.ext.autoconfigure.hazelcast.DuibaHazelcastPortService;
import com.hazelcast.core.HazelcastInstance;

import javax.annotation.Resource;
import java.util.Map;

/**
 * @author liuyao
 */
public class EurekaHazelcastDiscoveryRegister implements DiscoveryMetadataRegister {

    public static final String HAZELCAST_PORT = "hazelcast.port";
    public static final String HAZELCAST_VERSION = "hazelcast.version";

    private static final String VERSION = HazelcastInstance.class.getPackage().getImplementationVersion();

    @Resource
    private DuibaHazelcastPortService duibaHazelcastPortService;

    public static String getHazelcastVersion() {
        return VERSION;
    }

    /**
     * 注册hazelcast本机端口到eureka中
     */
    @Override
    public void registerMetadata(Map<String, String> appMetadata) {
        appMetadata.put(HAZELCAST_PORT, String.valueOf(duibaHazelcastPortService.getHazelcastPort()));
        appMetadata.put(HAZELCAST_VERSION, VERSION);
    }

}
