package cn.com.duibaboot.ext.autoconfigure.hazelcast;

import cn.com.duiba.boot.utils.NetUtils;
import cn.com.duibaboot.ext.autoconfigure.hazelcast.actuate.HazelcastEndpoint;
import cn.com.duibaboot.ext.autoconfigure.hazelcast.eureka.EurekaHazelcastDiscoveryConfiguration;
import com.hazelcast.config.Config;
import com.hazelcast.spring.context.SpringManagedContext;
import lombok.extern.slf4j.Slf4j;
import org.springframework.boot.actuate.hazelcast.HazelcastHealthIndicator;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

import java.util.List;
import java.util.Map;
import java.util.Objects;

/**
 * @author liuyao
 */
@Import({
        EurekaHazelcastDiscoveryConfiguration.class
})
@Slf4j
@EnableConfigurationProperties(DuibaHazelcastProperties.class)
public class DuibaHazelcastAutoConfiguration {

    /**
     * 确认Hazelcast端口号
     */
    @Bean
    public DuibaHazelcastPortService duibaHazelcastPortService(){
        return new DuibaHazelcastPortService();
    }

    /**
     * 打开 @SpringAware 的功能
     */
    @Bean
    public SpringManagedContext springManagedContext(){
        return new SpringManagedContext();
    }

    @Bean
    public Config hazelcastConfig(
            SpringManagedContext springManagedContext,
            DuibaHazelcastProperties duibaHazelcastProperties,
            List<HazelcastConfigPostProcessor> hazelcastConfigPostProcessors
    ){

        Config config = new Config();
        config.getNetworkConfig().getJoin().getMulticastConfig().setEnabled(false);
        config.getNetworkConfig().getJoin().getTcpIpConfig().setEnabled(false);
        config.getNetworkConfig().getJoin().getAwsConfig().setEnabled(false);
        config.setManagedContext(springManagedContext);

        config.setProperty("hazelcast.logging.type", "slf4j");
        //强制hazelcast使用这个ip来监听
        config.setProperty("hazelcast.local.localAddress", NetUtils.getLocalIp());

        config.setProperty("hazelcast.heartbeat.failuredetector.type", "deadline");
        config.setProperty("hazelcast.heartbeat.interval.seconds", "5");
        config.setProperty("hazelcast.max.no.heartbeat.seconds", "20");
        config.setProperty("hazelcast.socket.connect.timeout.seconds", "2");
        config.setProperty("hazelcast.socket.server.bind.any", "false");

        for(Map.Entry<String, String> entry : duibaHazelcastProperties.getProperties().entrySet()){
            config.setProperty(entry.getKey(), entry.getValue());
        }
        if(Objects.nonNull(hazelcastConfigPostProcessors)){
            postProcessorHazelcastConfig(config,hazelcastConfigPostProcessors);

        }
        return config;
    }

    private void postProcessorHazelcastConfig(Config config,List<HazelcastConfigPostProcessor> hazelcastConfigPostProcessorList){
        for(HazelcastConfigPostProcessor postProcessor:hazelcastConfigPostProcessorList){
            try{
                postProcessor.preProcessor(config);
            }catch (Exception e){
                log.error("预处理HazelcastConfig异常",e);
                throw new RuntimeException(e);
            }
        }
    }

    @Configuration
    @ConditionalOnClass(HazelcastHealthIndicator.class)
    public static class HazelcastEndpointConfiguration{

        @Bean
        public static HazelcastEndpoint hazelcastEndpoint() {
            return new HazelcastEndpoint();
        }

    }

}
