/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.hazelcast.actuate;

import com.hazelcast.cluster.ClusterState;
import com.hazelcast.cluster.Member;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.version.Version;
import java.util.Set;
import javax.annotation.Resource;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.boot.actuate.endpoint.annotation.Endpoint;
import org.springframework.boot.actuate.endpoint.annotation.ReadOperation;

@Endpoint(id="hazelcast")
public class HazelcastEndpoint {
    @Resource
    private ObjectFactory<HazelcastInstance> hazelcastInstanceObjectFactory;
    private volatile HazelcastInstance hazelcastInstance;

    @ReadOperation
    public HazelcastInfo getHazelcastInfo() {
        return HazelcastInfo.builder().clusterVersion(this.getHazelcastInstance().getCluster().getClusterVersion()).clusterState(this.getHazelcastInstance().getCluster().getClusterState()).members(this.getHazelcastInstance().getCluster().getMembers()).build();
    }

    public HazelcastInstance getHazelcastInstance() {
        if (this.hazelcastInstance == null) {
            this.hazelcastInstance = (HazelcastInstance)this.hazelcastInstanceObjectFactory.getObject();
        }
        return this.hazelcastInstance;
    }

    static class HazelcastInfo {
        private Version clusterVersion;
        private ClusterState clusterState;
        private Set<Member> members;

        HazelcastInfo(Version clusterVersion, ClusterState clusterState, Set<Member> members) {
            this.clusterVersion = clusterVersion;
            this.clusterState = clusterState;
            this.members = members;
        }

        public static HazelcastInfoBuilder builder() {
            return new HazelcastInfoBuilder();
        }

        public Version getClusterVersion() {
            return this.clusterVersion;
        }

        public ClusterState getClusterState() {
            return this.clusterState;
        }

        public Set<Member> getMembers() {
            return this.members;
        }

        public void setClusterVersion(Version clusterVersion) {
            this.clusterVersion = clusterVersion;
        }

        public void setClusterState(ClusterState clusterState) {
            this.clusterState = clusterState;
        }

        public void setMembers(Set<Member> members) {
            this.members = members;
        }

        public static class HazelcastInfoBuilder {
            private Version clusterVersion;
            private ClusterState clusterState;
            private Set<Member> members;

            HazelcastInfoBuilder() {
            }

            public HazelcastInfoBuilder clusterVersion(Version clusterVersion) {
                this.clusterVersion = clusterVersion;
                return this;
            }

            public HazelcastInfoBuilder clusterState(ClusterState clusterState) {
                this.clusterState = clusterState;
                return this;
            }

            public HazelcastInfoBuilder members(Set<Member> members) {
                this.members = members;
                return this;
            }

            public HazelcastInfo build() {
                return new HazelcastInfo(this.clusterVersion, this.clusterState, this.members);
            }

            public String toString() {
                return "HazelcastEndpoint.HazelcastInfo.HazelcastInfoBuilder(clusterVersion=" + this.clusterVersion + ", clusterState=" + this.clusterState + ", members=" + this.members + ")";
            }
        }
    }
}

