/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.hazelcast.eureka;

import cn.com.duibaboot.ext.autoconfigure.cloud.netflix.eureka.DiscoveryMetadataRegister;
import cn.com.duibaboot.ext.autoconfigure.hazelcast.DuibaHazelcastPortService;
import cn.com.duibaboot.ext.autoconfigure.hazelcast.eureka.EurekaHazelcastGroupManager;
import com.hazelcast.core.HazelcastInstance;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;

public class EurekaHazelcastDiscoveryRegister
implements DiscoveryMetadataRegister {
    public static final String HAZELCAST_PORT = "hazelcast.port";
    public static final String HAZELCAST_VERSION = "hazelcast.version";
    public static final String HAZELCAST_GROUP_KEY = "hazelcast.group.key";
    private static final String VERSION = HazelcastInstance.class.getPackage().getImplementationVersion();
    @Resource
    private DuibaHazelcastPortService duibaHazelcastPortService;
    @Resource
    private EurekaHazelcastGroupManager eurekaHazelcastGroupManager;

    public static String getHazelcastVersion() {
        return VERSION;
    }

    public void registerMetadata(Map<String, String> appMetadata) {
        appMetadata.put(HAZELCAST_PORT, String.valueOf(this.duibaHazelcastPortService.getHazelcastPort()));
        appMetadata.put(HAZELCAST_VERSION, VERSION);
        String groupKey = this.eurekaHazelcastGroupManager.getLocalGroupKey();
        if (StringUtils.isNotBlank((CharSequence)groupKey)) {
            appMetadata.put(HAZELCAST_GROUP_KEY, groupKey);
        }
    }
}

