package cn.com.duibaboot.ext.autoconfigure.hazelcast.actuate;


import com.hazelcast.cluster.ClusterState;
import com.hazelcast.cluster.Member;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.version.Version;
import lombok.Builder;
import lombok.Getter;
import lombok.Setter;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.boot.actuate.endpoint.annotation.Endpoint;
import org.springframework.boot.actuate.endpoint.annotation.ReadOperation;

import java.util.Set;
import javax.annotation.Resource;

/**
 * endpoint,可供查看hazelcast的集群状态、版本、集群成员等信息
 * @author liuyao
 */
@Endpoint(id="hazelcast")
public class HazelcastEndpoint {

    @Resource
    private ObjectFactory<HazelcastInstance> hazelcastInstanceObjectFactory;

    private volatile HazelcastInstance hazelcastInstance;

    @ReadOperation
    public HazelcastEndpoint.HazelcastInfo getHazelcastInfo() {
        return HazelcastInfo.builder()
                .clusterVersion(getHazelcastInstance().getCluster().getClusterVersion())
                .clusterState(getHazelcastInstance().getCluster().getClusterState())
                .members(getHazelcastInstance().getCluster().getMembers())
                .build();
    }

    public HazelcastInstance getHazelcastInstance(){
        if (hazelcastInstance == null) {
            hazelcastInstance = hazelcastInstanceObjectFactory.getObject();
        }

        return hazelcastInstance;
    }

    @Getter
    @Setter
    @Builder
    static class HazelcastInfo{
        private Version clusterVersion;
        private ClusterState clusterState;
        private Set<Member> members;
    }
}
