package cn.com.duibaboot.ext.autoconfigure.rocketmq;

import cn.com.duiba.wolf.perf.timeprofile.DBTimeProfile;
import cn.com.duibaboot.ext.autoconfigure.core.utils.CatUtils;
import cn.com.duibaboot.ext.autoconfigure.rocketmq.RocketMqProperties;
import com.google.common.base.Throwables;
import org.apache.rocketmq.client.consumer.listener.ConsumeConcurrentlyContext;
import org.apache.rocketmq.client.consumer.listener.ConsumeConcurrentlyStatus;
import org.apache.rocketmq.client.consumer.listener.MessageListenerConcurrently;
import org.apache.rocketmq.common.message.MessageExt;
import org.springframework.beans.factory.BeanNameAware;

import java.util.List;

/**
 * RocketMQ MessageListener的包装，增加cat监控
 */
public class MessageListenerConcurrentlyWrapper implements MessageListenerConcurrently, BeanNameAware {

    private MessageListenerConcurrently source;

    private String beanName;
    private RocketMqProperties.ConsumerProperties consumerProperties;

    public MessageListenerConcurrentlyWrapper(MessageListenerConcurrently source, String beanName){
        this.source = source;
        this.beanName = beanName;
    }

    @Override
    public ConsumeConcurrentlyStatus consumeMessage(List<MessageExt> msgs, ConsumeConcurrentlyContext context) {
        DBTimeProfile.start();
        try {
            return CatUtils.executeInCatTransaction(() -> source.consumeMessage(msgs, context),
                    "MessageQueue", "RocketMQ.consume");
        } catch(Throwable e) {
            throw Throwables.propagate(e);
        } finally {
            DBTimeProfile.end("RocketMQ.consume");
        }
    }

    @Override
    public void setBeanName(String name) {
        this.beanName = name;
    }

    public String getBeanName() {
        return beanName;
    }

    public RocketMqProperties.ConsumerProperties getConsumerProperties() {
        return consumerProperties;
    }

    public void setConsumerProperties(RocketMqProperties.ConsumerProperties consumerProperties) {
        this.consumerProperties = consumerProperties;
    }
}
