/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.rocketmq;

import cn.com.duiba.wolf.perf.timeprofile.DBTimeProfile;
import cn.com.duibaboot.ext.autoconfigure.core.utils.CatUtils;
import cn.com.duibaboot.ext.autoconfigure.rocketmq.RocketMqProperties;
import com.google.common.base.Throwables;
import java.util.List;
import org.apache.rocketmq.client.consumer.listener.ConsumeOrderlyContext;
import org.apache.rocketmq.client.consumer.listener.ConsumeOrderlyStatus;
import org.apache.rocketmq.client.consumer.listener.MessageListenerOrderly;
import org.apache.rocketmq.common.message.MessageExt;
import org.springframework.beans.factory.BeanNameAware;

public class MessageListenerOrderlyWrapper
implements MessageListenerOrderly,
BeanNameAware {
    private MessageListenerOrderly source;
    private String beanName;
    private RocketMqProperties.ConsumerProperties consumerProperties;

    public MessageListenerOrderlyWrapper(MessageListenerOrderly source, String beanName) {
        this.source = source;
        this.beanName = beanName;
    }

    public ConsumeOrderlyStatus consumeMessage(List<MessageExt> msgs, ConsumeOrderlyContext context) {
        DBTimeProfile.start();
        try {
            ConsumeOrderlyStatus consumeOrderlyStatus = (ConsumeOrderlyStatus)CatUtils.executeInCatTransaction(() -> this.source.consumeMessage(msgs, context), (String)"MessageQueue", (String)"RocketMQ.consume");
            return consumeOrderlyStatus;
        }
        catch (Throwable e) {
            throw Throwables.propagate((Throwable)e);
        }
        finally {
            DBTimeProfile.end((String)"RocketMQ.consume");
        }
    }

    public void setBeanName(String name) {
        this.beanName = name;
    }

    public String getBeanName() {
        return this.beanName;
    }

    public RocketMqProperties.ConsumerProperties getConsumerProperties() {
        return this.consumerProperties;
    }

    public void setConsumerProperties(RocketMqProperties.ConsumerProperties consumerProperties) {
        this.consumerProperties = consumerProperties;
    }
}

