/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.rocketmq;

import cn.com.duiba.boot.event.MainContextRefreshedEvent;
import cn.com.duibaboot.ext.autoconfigure.core.SpecifiedBeanPostProcessor;
import cn.com.duibaboot.ext.autoconfigure.rocketmq.DefaultMQProducerWrapper;
import cn.com.duibaboot.ext.autoconfigure.rocketmq.DefaultMQPushConsumerWrapper;
import cn.com.duibaboot.ext.autoconfigure.rocketmq.RocketMqProperties;
import cn.com.duibaboot.ext.autoconfigure.rocketmq.RocketmqMessageListenerPostProcessor;
import cn.com.duibaboot.ext.autoconfigure.rocketmq.grouping.RocketMqMessageFilter;
import cn.com.duibaboot.ext.autoconfigure.rocketmq.grouping.RocketMqMessageListenerPostProcessor4Group;
import cn.com.duibaboot.ext.autoconfigure.rocketmq.grouping.RocketMqProducerServiceGroupAspect;
import com.netflix.discovery.EurekaClient;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Map;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import org.apache.rocketmq.client.consumer.DefaultMQPushConsumer;
import org.apache.rocketmq.client.consumer.listener.MessageListener;
import org.apache.rocketmq.client.exception.MQClientException;
import org.apache.rocketmq.client.producer.DefaultMQProducer;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.event.EventListener;
import org.springframework.core.annotation.Order;

@Configuration
@ConditionalOnClass(value={DefaultMQProducer.class})
@EnableConfigurationProperties(value={RocketMqProperties.class})
public class RocketMqAutoConfiguration {

    @Configuration
    @ConditionalOnClass(value={DefaultMQPushConsumer.class})
    protected static class RocketMqConsumerConfigurator
    extends RocketMqClientConfiguration {
        protected RocketMqConsumerConfigurator() {
        }

        @Bean
        public static SpecifiedBeanPostProcessor<MessageListener> rocketmqMessageListenerPostProcessor() {
            return new RocketmqMessageListenerPostProcessor();
        }

        @Bean(name={"rocketMqConsumer"})
        @ConditionalOnMissingBean(name={"rocketMqConsumer"})
        @ConditionalOnProperty(name={"duiba.rocketmq.consumer.enable"}, havingValue="true", matchIfMissing=false)
        public DefaultMQPushConsumerWrapper rocketMqConsumer() {
            return new DefaultMQPushConsumerWrapper(this.rocketMqProperties, -1);
        }

        @Bean(name={"extraRocketMqConsumer0"})
        @ConditionalOnMissingBean(name={"extraRocketMqConsumer0"})
        @ConditionalOnProperty(name={"duiba.rocketmq.extra-consumer[0].enable"}, havingValue="true", matchIfMissing=false)
        public DefaultMQPushConsumerWrapper extraRocketMqConsumer0() {
            return new DefaultMQPushConsumerWrapper(this.rocketMqProperties, 0);
        }

        @Bean(name={"extraRocketMqConsumer1"})
        @ConditionalOnMissingBean(name={"extraRocketMqConsumer1"})
        @ConditionalOnProperty(name={"duiba.rocketmq.extra-consumer[1].enable"}, havingValue="true", matchIfMissing=false)
        public DefaultMQPushConsumerWrapper extraRocketMqConsumer1() {
            return new DefaultMQPushConsumerWrapper(this.rocketMqProperties, 1);
        }

        @Bean(name={"extraRocketMqConsumer2"})
        @ConditionalOnMissingBean(name={"extraRocketMqConsumer2"})
        @ConditionalOnProperty(name={"duiba.rocketmq.extra-consumer[2].enable"}, havingValue="true", matchIfMissing=false)
        public DefaultMQPushConsumerWrapper extraRocketMqConsumer2() {
            return new DefaultMQPushConsumerWrapper(this.rocketMqProperties, 2);
        }

        @EventListener(value={MainContextRefreshedEvent.class})
        @Order(value=0x7FFFFFFF)
        public void onEvent(MainContextRefreshedEvent event) {
            Map map = event.getApplicationContext().getBeansOfType(DefaultMQPushConsumerWrapper.class);
            if (!map.isEmpty()) {
                for (DefaultMQPushConsumerWrapper consumer : map.values()) {
                    try {
                        if (consumer == null) continue;
                        consumer.startRun();
                    }
                    catch (MQClientException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        }
    }

    @Configuration
    @ConditionalOnClass(value={DefaultMQProducer.class})
    @ConditionalOnMissingBean(name={"rocketMqProducer"})
    @ConditionalOnProperty(name={"duiba.rocketmq.producer.enable"}, havingValue="true", matchIfMissing=false)
    protected static class RocketMqProducerConfigurator
    extends RocketMqClientConfiguration {
        protected RocketMqProducerConfigurator() {
        }

        @Bean(name={"rocketMqProducer"}, destroyMethod="shutdown")
        public DefaultMQProducer rocketMqProducer() throws MQClientException {
            DefaultMQProducerWrapper p = new DefaultMQProducerWrapper();
            p.setProducerGroup(this.rocketMqProperties.getProducer().getGroup());
            p.setNamesrvAddr(this.rocketMqProperties.getNameSrvAddr());
            p.setSendMsgTimeout(this.rocketMqProperties.getProducer().getSendMsgTimeoutMillis());
            p.start();
            return p;
        }
    }

    @Configuration
    @ConditionalOnClass(value={DefaultMQProducer.class, EurekaClient.class})
    @ConditionalOnProperty(value={"eureka.client.enabled"}, havingValue="true", matchIfMissing=true)
    static class RocketMqServiceGroupConfiguration {
        RocketMqServiceGroupConfiguration() {
        }

        @Bean
        public RocketMqProducerServiceGroupAspect rocketMqProducerServiceGroupAspect() {
            return new RocketMqProducerServiceGroupAspect();
        }

        @Bean
        public static SpecifiedBeanPostProcessor<MessageListener> rocketMqMessageListenerPostProcessor4Group() {
            return new RocketMqMessageListenerPostProcessor4Group();
        }
    }

    @Configuration
    @ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
    static class RocketMqMessageGroupConfiguration {
        RocketMqMessageGroupConfiguration() {
        }

        @Bean
        public RocketMqMessageFilter rocketMqMessageGroupFilter() {
            return new RocketMqMessageFilter();
        }

        @Bean
        public FilterRegistrationBean<RocketMqMessageFilter> rocketMqMessageGroupConfigurer(RocketMqMessageFilter rocketMqMessageGroupFilter) {
            FilterRegistrationBean registrationBean = new FilterRegistrationBean();
            registrationBean.setFilter((Filter)rocketMqMessageGroupFilter);
            ArrayList<String> urlPatterns = new ArrayList<String>();
            urlPatterns.add("/bootext/serviceGroup/rocketmqMsgDispatch");
            registrationBean.setUrlPatterns(urlPatterns);
            registrationBean.setDispatcherTypes(EnumSet.of(DispatcherType.REQUEST));
            registrationBean.setOrder(-2147483644);
            return registrationBean;
        }
    }

    protected static abstract class RocketMqClientConfiguration {
        @Autowired
        protected RocketMqProperties rocketMqProperties;

        protected RocketMqClientConfiguration() {
        }
    }
}

