package cn.com.duibaboot.ext.autoconfigure.rocketmq;

import cn.com.duibaboot.ext.autoconfigure.rocketmq.duiba.RocketMqConsumerConfigurator;
import cn.com.duibaboot.ext.autoconfigure.rocketmq.hook.RocketmqConsumeMessageHookSetter;
import org.apache.rocketmq.spring.autoconfigure.ListenerContainerConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.EnableAspectJAutoProxy;
import org.springframework.context.annotation.Import;

/**
 * RocketMQ生产者/消费者自动配置
 *
 * @author wenqi.huang
 */
@Configuration
@EnableAspectJAutoProxy
@AutoConfigureAfter(ListenerContainerConfiguration.class)
@Import(RocketMqConsumerConfigurator.class)
public class DuibaRocketMqAutoConfiguration {

    @Bean
    public RocketmqConsumeMessageHookSetter rocketmqConsumeHookSetter(){
        return new RocketmqConsumeMessageHookSetter();
    }

}
