package cn.com.duibaboot.ext.autoconfigure.rocketmq;

import cn.com.duibaboot.ext.autoconfigure.core.SpecifiedBeanPostProcessor;
import cn.com.duibaboot.ext.autoconfigure.rocketmq.duiba.RocketMqConsumerConfigurator;
import cn.com.duibaboot.ext.autoconfigure.rocketmq.grouping.RocketMqMessageListenerPostProcessor4Group;
import cn.com.duibaboot.ext.autoconfigure.rocketmq.grouping.RocketMqProducerServiceGroupAspect;
import cn.com.duibaboot.ext.autoconfigure.rocketmq.grouping.RocketMqServiceGroupFilter;
import cn.com.duibaboot.ext.autoconfigure.rocketmq.grouping.RocketmqMessageListenerPostProcessor;
import cn.com.duibaboot.ext.autoconfigure.rocketmq.hook.RocketmqConsumeMessageHookSetter;
import com.alibaba.ttl.TransmittableThreadLocal;
import com.netflix.discovery.EurekaClient;
import org.apache.rocketmq.client.consumer.listener.MessageListener;
import org.apache.rocketmq.spring.autoconfigure.ListenerContainerConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.EnableAspectJAutoProxy;
import org.springframework.context.annotation.Import;
import org.springframework.core.Ordered;

import javax.servlet.DispatcherType;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;

/**
 * RocketMQ生产者/消费者自动配置
 *
 * @author wenqi.huang
 */
@Configuration
@EnableAspectJAutoProxy
@AutoConfigureAfter(ListenerContainerConfiguration.class)
@Import(RocketMqConsumerConfigurator.class)
public class DuibaRocketMqAutoConfiguration {

    @Bean
    public RocketmqConsumeMessageHookSetter rocketmqConsumeHookSetter(){
        return new RocketmqConsumeMessageHookSetter();
    }

    /**
     * 加入AOP，多场景测试支持rocketmq, 如果当前服务器的场景ID刚好和消息中的场景ID相同，则直接处理即可；
     * 如果当前服务器的场景ID（或者当前服务器没有场景ID）和消息中的场景ID不同，则去eureka中找到具有相同场景ID的服务，并转发给对应服务处理。
     */
    @Configuration
    @ConditionalOnClass({ EurekaClient.class })
    @ConditionalOnProperty(value = "eureka.client.enabled", havingValue = "true", matchIfMissing = true)
    static class RocketMqServiceGroupConfiguration {

        @Bean
        public RocketMqProducerServiceGroupAspect rocketMqProducerServiceGroupAspect() {
            return new RocketMqProducerServiceGroupAspect();
        }

        @Bean
        public static SpecifiedBeanPostProcessor<MessageListener> rocketMqMessageListenerPostProcessor4Group() {
            return new RocketMqMessageListenerPostProcessor4Group();
        }

        @Bean
        public static SpecifiedBeanPostProcessor<MessageListener> rocketmqMessageListenerPostProcessor() {
            return new RocketmqMessageListenerPostProcessor();
        }
    }

    @Configuration
    @ConditionalOnClass({ TransmittableThreadLocal.class })
    @ConditionalOnWebApplication(type = ConditionalOnWebApplication.Type.SERVLET)
    static class RocketMqServiceGroupFilterConfigurationServlet {

        @Bean
        public RocketMqServiceGroupFilter rocketMqServiceGroupFilter() {
            return new RocketMqServiceGroupFilter();
        }

        @Bean
        public FilterRegistrationBean rocketMqServiceGroupFilterConfigurer(RocketMqServiceGroupFilter rocketMqServiceGroupFilter) {
            FilterRegistrationBean registrationBean = new FilterRegistrationBean();
            registrationBean.setFilter(rocketMqServiceGroupFilter);
            List<String> urlPatterns = new ArrayList<>();
            urlPatterns.add("/*");//拦截路径，可以添加多个
            registrationBean.setUrlPatterns(urlPatterns);
            registrationBean.setDispatcherTypes(EnumSet.of(DispatcherType.REQUEST));
            registrationBean.setOrder(Ordered.HIGHEST_PRECEDENCE + 4);
            return registrationBean;
        }

    }
}
