package cn.com.duibaboot.ext.autoconfigure.rocketmq.hook;

import cn.com.duiba.boot.event.MainContextRefreshedEvent;
import org.apache.rocketmq.client.consumer.DefaultMQPushConsumer;
import org.apache.rocketmq.client.hook.ConsumeMessageHook;
import org.apache.rocketmq.client.hook.SendMessageHook;
import org.apache.rocketmq.client.impl.consumer.DefaultMQPushConsumerImpl;
import org.apache.rocketmq.client.impl.producer.DefaultMQProducerImpl;
import org.apache.rocketmq.client.producer.DefaultMQProducer;
import org.apache.rocketmq.spring.autoconfigure.ListenerContainerConfiguration;
import org.apache.rocketmq.spring.support.DefaultRocketMQListenerContainer;
import org.aspectj.lang.annotation.After;
import org.aspectj.lang.annotation.Aspect;
import org.springframework.beans.factory.SmartInitializingSingleton;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.event.EventListener;
import org.springframework.core.Ordered;
import org.springframework.core.annotation.Order;

import javax.annotation.Resource;
import java.util.List;
import java.util.Map;

/**
 * @author liuyao
 */
@Aspect
public class RocketmqConsumeMessageHookSetter{

    @Resource
    private ApplicationContext applicationContext;
    @Autowired(required = false)
    private List<ConsumeMessageHook> consumeMessageHooks;

    /**
     * 在所有监听器初始化完成后，注入hook
     */
    @After("execution(* org.apache.rocketmq.spring.autoconfigure.ListenerContainerConfiguration.afterSingletonsInstantiated(..))")
    public void afterSingletonsInstantiated() {
        if(consumeMessageHooks==null || consumeMessageHooks.isEmpty()){
            return;
        }
        Map<String, DefaultRocketMQListenerContainer> containers = applicationContext.getBeansOfType(DefaultRocketMQListenerContainer.class);
        for(DefaultRocketMQListenerContainer container:containers.values()){
            DefaultMQPushConsumer consumer = container.getConsumer();
            DefaultMQPushConsumerImpl mqPushConsumer = consumer.getDefaultMQPushConsumerImpl();
            for(ConsumeMessageHook hook:consumeMessageHooks){
                mqPushConsumer.registerConsumeMessageHook(hook);
            }
        }
    }
}
