package cn.com.duibaboot.ext.autoconfigure.rocketmq.sleuth;

import org.apache.rocketmq.client.hook.ConsumeMessageContext;
import org.apache.rocketmq.client.hook.ConsumeMessageHook;
import org.apache.rocketmq.common.message.MessageExt;

import java.util.List;
import java.util.Objects;

public class RocketmqSleuthConsumeMessageHook implements ConsumeMessageHook {

    private final ThreadLocal<RocketmqSleuthContext> contextThreadLocal = new ThreadLocal<>();

    @Override
    public String hookName() {
        return "sleuth-hook";
    }

    protected RocketmqSleuthContext getRocketmqSleuthContext(){
        return contextThreadLocal.get();
    }

    @Override
    public void consumeMessageBefore(ConsumeMessageContext context) {
        List<MessageExt> messages = context.getMsgList();
        if(Objects.isNull(messages) || messages.isEmpty()){
            return;
        }
        RocketmqSleuthContext sleuthContext = new RocketmqSleuthContext();
        sleuthContext.initContext(messages);
        contextThreadLocal.set(sleuthContext);
    }

    @Override
    public void consumeMessageAfter(ConsumeMessageContext context) {
        contextThreadLocal.remove();
    }
}
