/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.rocketmq.duiba;

import cn.com.duibaboot.ext.autoconfigure.rocketmq.duiba.ConsumerProperties;
import cn.com.duibaboot.ext.autoconfigure.rocketmq.grouping.MessageListenerConcurrentlyWrapper;
import cn.com.duibaboot.ext.autoconfigure.rocketmq.grouping.MessageListenerOrderlyWrapper;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Resource;
import org.apache.rocketmq.client.consumer.DefaultMQPushConsumer;
import org.apache.rocketmq.client.consumer.listener.MessageListener;
import org.apache.rocketmq.client.consumer.listener.MessageListenerConcurrently;
import org.apache.rocketmq.client.consumer.listener.MessageListenerOrderly;
import org.apache.rocketmq.client.exception.MQClientException;
import org.apache.rocketmq.common.protocol.heartbeat.MessageModel;
import org.apache.rocketmq.spring.autoconfigure.RocketMQProperties;
import org.apache.rocketmq.spring.support.RocketMQListenerContainer;
import org.apache.rocketmq.spring.support.RocketMQUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.SmartLifecycle;
import org.springframework.util.Assert;

public class DuibaRocketmqListenerContainer
implements InitializingBean,
RocketMQListenerContainer,
SmartLifecycle {
    private static final Logger log = LoggerFactory.getLogger(DuibaRocketmqListenerContainer.class);
    private static final String DEFAULT = "bootRocketMqMessageListener";
    private static final String PREFIX = "extraBootRocketMqMessageListener";
    @Resource
    private ApplicationContext applicationContext;
    @Resource
    private RocketMQProperties rocketMqProperties;
    private ConsumerProperties consumerProperties;
    private Integer index;
    private String consumerGroup;
    private int consumeThreadMax = 64;
    private DefaultMQPushConsumer consumer;
    private boolean running;
    private org.apache.rocketmq.spring.annotation.MessageModel messageModel;

    public ConsumerProperties getConsumerProperties() {
        return this.consumerProperties;
    }

    public void setConsumerProperties(ConsumerProperties consumerProperties) {
        this.consumerProperties = consumerProperties;
        this.consumerGroup = consumerProperties.getGroup();
        this.consumeThreadMax = Optional.ofNullable(consumerProperties.getConsumeThreadNums()).orElse(64);
        this.messageModel = consumerProperties.getMessageModel();
    }

    public Integer getIndex() {
        return this.index;
    }

    public void setIndex(Integer index) {
        this.index = index;
    }

    public org.apache.rocketmq.spring.annotation.MessageModel getMessageModel() {
        return this.messageModel;
    }

    public DefaultMQPushConsumer getConsumer() {
        return this.consumer;
    }

    public void setConsumer(DefaultMQPushConsumer consumer) {
        this.consumer = consumer;
    }

    public void destroy() {
        this.setRunning(false);
        if (Objects.nonNull(this.consumer)) {
            this.consumer.shutdown();
        }
        log.info("container destroyed, {}", (Object)this.toString());
    }

    public boolean isAutoStartup() {
        return false;
    }

    public void stop(Runnable callback) {
        this.stop();
        callback.run();
    }

    public void start() {
        if (this.isRunning()) {
            throw new IllegalStateException("container already running. " + this.toString());
        }
        try {
            this.consumer.start();
        }
        catch (MQClientException e) {
            throw new IllegalStateException("Failed to start RocketMQ push consumer", e);
        }
        this.setRunning(true);
        log.info("running container: {}", (Object)this.toString());
    }

    public void stop() {
        if (this.isRunning()) {
            if (Objects.nonNull(this.consumer)) {
                this.consumer.shutdown();
            }
            this.setRunning(false);
        }
    }

    public boolean isRunning() {
        return this.running;
    }

    private void setRunning(boolean running) {
        this.running = running;
    }

    public int getPhase() {
        return Integer.MAX_VALUE;
    }

    public void afterPropertiesSet() throws Exception {
        MessageListener rocketMqMessageListener;
        String[] topicArr;
        Assert.notNull((Object)this.consumerGroup, (String)"Property 'consumerGroup' is required");
        Assert.notNull((Object)this.rocketMqProperties.getNameServer(), (String)"Property 'nameServer' is required");
        Assert.notNull((Object)this.consumerProperties.getTopics(), (String)"Property 'topic' is required");
        this.consumer = new DefaultMQPushConsumer(this.consumerGroup, false);
        this.consumer.setInstanceName(RocketMQUtil.getInstanceName((String)this.rocketMqProperties.getNameServer()));
        this.consumer.setNamesrvAddr(this.rocketMqProperties.getNameServer());
        this.consumer.setConsumeThreadMax(this.consumeThreadMax);
        this.consumer.setConsumeMessageBatchMaxSize(this.consumerProperties.getConsumeMessageBatchMaxSize().intValue());
        if (this.consumeThreadMax < this.consumer.getConsumeThreadMin()) {
            this.consumer.setConsumeThreadMin(this.consumeThreadMax);
        }
        int maxReconsumeTimes = this.consumerProperties.getMaxReconsumeTimes();
        this.consumer.setMaxReconsumeTimes(maxReconsumeTimes);
        switch (this.messageModel) {
            case BROADCASTING: {
                this.consumer.setMessageModel(MessageModel.BROADCASTING);
                break;
            }
            case CLUSTERING: {
                this.consumer.setMessageModel(MessageModel.CLUSTERING);
                break;
            }
            default: {
                throw new IllegalArgumentException("Property 'messageModel' was wrong.");
            }
        }
        String topics = this.consumerProperties.getTopics();
        for (String topic : topicArr = topics.split(",")) {
            this.consumer.subscribe(topic, "*");
        }
        String messageListenerBeanId = this.buildBeanName(this.index);
        try {
            rocketMqMessageListener = (MessageListener)this.applicationContext.getBean(messageListenerBeanId, MessageListener.class);
        }
        catch (NoSuchBeanDefinitionException e) {
            throw new IllegalStateException("bean id:[" + messageListenerBeanId + "] class:[org.apache.rocketmq.client.consumer.listener.MessageListenerConcurrently] is not exist in spring's context, \u8bf7\u58f0\u660e\uff0c\u5426\u5219\u4e0d\u4f1a\u542f\u7528rocketmq\u6d88\u8d39!!!\uff0c\u8bf7\u53c2\u8003: http://gitlab2.dui88.com/basic_platform/spring-boot-ext/wikis/Starter%E7%89%B9%E6%80%A7/_rocketmq%E3%80%90%E5%BC%80%E6%BA%90RocketMQ%E3%80%91");
        }
        if (rocketMqMessageListener instanceof MessageListenerConcurrently) {
            this.consumer.registerMessageListener((MessageListenerConcurrently)rocketMqMessageListener);
            if (rocketMqMessageListener instanceof MessageListenerConcurrentlyWrapper) {
                ((MessageListenerConcurrentlyWrapper)rocketMqMessageListener).setConsumerProperties(this.consumerProperties);
            }
        } else if (rocketMqMessageListener instanceof MessageListenerOrderly) {
            this.consumer.registerMessageListener((MessageListenerOrderly)rocketMqMessageListener);
            if (rocketMqMessageListener instanceof MessageListenerOrderlyWrapper) {
                ((MessageListenerOrderlyWrapper)rocketMqMessageListener).setConsumerProperties(this.consumerProperties);
            }
        }
    }

    public String buildBeanName(Integer index) {
        if (Objects.isNull(index)) {
            return DEFAULT;
        }
        return PREFIX + index;
    }
}

