/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.rocketmq.hook;

import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.rocketmq.client.consumer.DefaultMQPushConsumer;
import org.apache.rocketmq.client.hook.ConsumeMessageHook;
import org.apache.rocketmq.client.impl.consumer.DefaultMQPushConsumerImpl;
import org.apache.rocketmq.spring.support.DefaultRocketMQListenerContainer;
import org.aspectj.lang.annotation.After;
import org.aspectj.lang.annotation.Aspect;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;

@Aspect
public class RocketmqConsumeMessageHookSetter {
    @Resource
    private ApplicationContext applicationContext;
    @Autowired(required=false)
    private List<ConsumeMessageHook> consumeMessageHooks;

    @After(value="execution(* org.apache.rocketmq.spring.autoconfigure.ListenerContainerConfiguration.afterSingletonsInstantiated(..))")
    public void afterSingletonsInstantiated() {
        if (this.consumeMessageHooks == null || this.consumeMessageHooks.isEmpty()) {
            return;
        }
        Map containers = this.applicationContext.getBeansOfType(DefaultRocketMQListenerContainer.class);
        for (DefaultRocketMQListenerContainer container : containers.values()) {
            DefaultMQPushConsumer consumer = container.getConsumer();
            DefaultMQPushConsumerImpl mqPushConsumer = consumer.getDefaultMQPushConsumerImpl();
            for (ConsumeMessageHook hook : this.consumeMessageHooks) {
                mqPushConsumer.registerConsumeMessageHook(hook);
            }
        }
    }
}

