package cn.com.duibaboot.ext.autoconfigure.rocketmq.duiba;

import org.apache.rocketmq.spring.annotation.MessageModel;

/**
 * @author liuyao
 */
public class ConsumerProperties {

    /**
     * 是否启用RocketMQ消费者
     */
    private Boolean enable = false;

    /**
     * 即ConsumerId
     */
    private String group;

    /**
     * 需要订阅的topic，多个用英文半角逗号隔开
     */
    private String topics;

    /**
     * 消费模型：CLUSTERING/BROADCASTING,分别表示集群消费模型/广播消费模型,默认是集群消费模型<br/>
     * 集群消费模式是指某个topic、group下的一个消息只会被集群中的随机一台机器消费；<br/>
     * 广播消费模式是指某个topic、group下的一个消息会被集群中的每一台机器消费。<br/>
     * 这个模式参数非常重要，会对当前consumer订阅的所有topic都生效，所以如果一开始确定了某种消费模式，修改时请务必谨慎。
     */
    private MessageModel messageModel = MessageModel.CLUSTERING;

    /**
     * 消息消费的最大重试次数，默认16
     */
    private Integer maxReconsumeTimes = 16;
    /**
     * 消费线程数量, 最大为 consumeThreadNums,默认64， 最小 min(20,consumeThreadNums)
     */
    private Integer consumeThreadNums;

    /**
     * MessageListener监听器每次接受本地队列的消息是多少条(默认1条，注意这个配置不能控制每次从rocketmq服务器拉取的条数）
     */
    private Integer consumeMessageBatchMaxSize = 1;

    public Integer getConsumeMessageBatchMaxSize() {
        return consumeMessageBatchMaxSize;
    }

    public void setConsumeMessageBatchMaxSize(Integer consumeMessageBatchMaxSize) {
        this.consumeMessageBatchMaxSize = consumeMessageBatchMaxSize;
    }

    public Boolean getEnable() {
        return enable;
    }

    public void setEnable(Boolean enable) {
        this.enable = enable;
    }

    public String getGroup() {
        return group;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public Integer getMaxReconsumeTimes() {
        return maxReconsumeTimes;
    }

    public void setMaxReconsumeTimes(Integer maxReconsumeTimes) {
        this.maxReconsumeTimes = maxReconsumeTimes;
    }

    public Integer getConsumeThreadNums() {
        return consumeThreadNums;
    }

    public void setConsumeThreadNums(Integer consumeThreadNums) {
        this.consumeThreadNums = consumeThreadNums;
    }

    public String getTopics() {
        return topics;
    }

    public void setTopics(String topics) {
        this.topics = topics;
    }

    public MessageModel getMessageModel() {
        return messageModel;
    }

    public void setMessageModel(MessageModel messageModel) {
        this.messageModel = messageModel;
    }

}
