package cn.com.duibaboot.ext.autoconfigure.rocketmq.grouping;

import cn.com.duiba.boot.utils.NetUtils;
import cn.com.duiba.boot.utils.RequestUtils;
import cn.com.duiba.wolf.perf.timeprofile.RequestTool;
import cn.com.duibaboot.ext.autoconfigure.cloud.netflix.feign.DuibaFeignProperties;
import org.apache.commons.io.IOUtils;
import org.springframework.context.ApplicationContext;

import javax.annotation.Resource;
import javax.servlet.*;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;

public class RocketMqServiceGroupFilter implements Filter {

    public static final String ROCKETMQ_MSG_DISPATCH_PATH = "/bootext/serviceGroup/rocketmqMsgDispatch";

    @Resource
    private ApplicationContext applicationContext;

    @Override
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest req = (HttpServletRequest) request;
        String uri = RequestUtils.getRequestPath(req);
        if (!ROCKETMQ_MSG_DISPATCH_PATH.equals(uri)) {
            chain.doFilter(request, response);
            return;
        }
        HttpServletResponse resp = (HttpServletResponse) response;
        String ip = RequestTool.getIpAddr(req);
        if (!NetUtils.isReservedIp(ip)) {
            response.getWriter().print("error");
            return;
        }

        byte[] bs = IOUtils.toByteArray(req.getInputStream());
        RocketMqMessageListenerPostProcessor4Group.RocketMqRunInOtherNodeTask task = DuibaFeignProperties.DuibaFeignSerialization.HESSIAN2.deserialize(bs);
        task.setApplicationContext(applicationContext);

        Object obj = task.call();

        byte[] returnBs = DuibaFeignProperties.DuibaFeignSerialization.HESSIAN2.serialize(obj);
        IOUtils.write(returnBs, resp.getOutputStream());
    }

}
