package org.springframework.cloud.stream.binder.rocketmq.config;

import cn.com.duibaboot.ext.stream.binder.BinderFactoryBean;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.springframework.cloud.stream.binder.rocketmq.RocketMQMessageChannelBinder;
import org.springframework.cloud.stream.binder.rocketmq.metrics.InstrumentationManager;
import org.springframework.context.ApplicationContext;

import javax.annotation.Resource;

/**
 * @author liuyao
 */
public class RocketMQBinderFactoryBean extends BinderFactoryBean<RocketMQMessageChannelBinder> {

    @Resource
    private InstrumentationManager instrumentationManager;
    @Resource
    private ApplicationContext applicationContext;
    @Resource
    private ObjectMapper objectMapper;


    @Override
    public RocketMQMessageChannelBinder getObject() {
        RocketMQMessageChannelBinder binder = new RocketMQMessageChannelBinder();
        binder.setApplicationContext(applicationContext);
        binder.setInstrumentationManager(instrumentationManager);
        binder.setObjectMapper(objectMapper);
        return binder;
    }

    @Override
    public Class<?> getObjectType() {
        return RocketMQMessageChannelBinder.class;
    }
}
