/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.stream.converter;

import cn.com.duibaboot.ext.stream.config.BindingProperties;
import cn.com.duibaboot.ext.stream.converter.ApplicationJsonMessageMarshallingConverter;
import cn.com.duibaboot.ext.stream.converter.ConversionException;
import cn.com.duibaboot.ext.stream.converter.ObjectStringMessageConverter;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.messaging.converter.AbstractMessageConverter;
import org.springframework.messaging.converter.ByteArrayMessageConverter;
import org.springframework.messaging.converter.CompositeMessageConverter;
import org.springframework.messaging.converter.ContentTypeResolver;
import org.springframework.messaging.converter.DefaultContentTypeResolver;
import org.springframework.messaging.converter.MessageConverter;
import org.springframework.util.CollectionUtils;
import org.springframework.util.MimeType;

public class CompositeMessageConverterFactory {
    private static final Logger log = LoggerFactory.getLogger(CompositeMessageConverterFactory.class);
    private final ObjectMapper objectMapper;
    private final List<MessageConverter> converters;

    public CompositeMessageConverterFactory() {
        this(Collections.emptyList(), new ObjectMapper());
    }

    public CompositeMessageConverterFactory(List<? extends MessageConverter> customConverters, ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
        this.converters = !CollectionUtils.isEmpty(customConverters) ? new ArrayList<MessageConverter>(customConverters) : new ArrayList<MessageConverter>();
        this.initDefaultConverters();
        DefaultContentTypeResolver resolver = new DefaultContentTypeResolver();
        resolver.setDefaultMimeType(BindingProperties.DEFAULT_CONTENT_TYPE);
        this.converters.stream().filter(mc -> mc instanceof AbstractMessageConverter).forEach(mc -> ((AbstractMessageConverter)mc).setContentTypeResolver((ContentTypeResolver)resolver));
    }

    private void initDefaultConverters() {
        ApplicationJsonMessageMarshallingConverter applicationJsonConverter = new ApplicationJsonMessageMarshallingConverter(this.objectMapper);
        applicationJsonConverter.setStrictContentTypeMatch(true);
        this.converters.add((MessageConverter)applicationJsonConverter);
        this.converters.add((MessageConverter)new ByteArrayMessageConverter(){

            protected boolean supports(Class<?> clazz) {
                if (!super.supports(clazz)) {
                    return Object.class == clazz;
                }
                return true;
            }
        });
        this.converters.add((MessageConverter)new ObjectStringMessageConverter());
    }

    public MessageConverter getMessageConverterForType(MimeType mimeType) {
        ArrayList<MessageConverter> converters = new ArrayList<MessageConverter>();
        for (MessageConverter converter : this.converters) {
            if (converter instanceof AbstractMessageConverter) {
                for (MimeType type : ((AbstractMessageConverter)converter).getSupportedMimeTypes()) {
                    if (!type.includes(mimeType)) continue;
                    converters.add(converter);
                }
                continue;
            }
            if (!log.isDebugEnabled()) continue;
            log.debug("Ommitted " + converter + " of type " + converter.getClass().toString() + " for '" + mimeType.toString() + "' as it is not an AbstractMessageConverter");
        }
        if (CollectionUtils.isEmpty(converters)) {
            throw new ConversionException("No message converter is registered for " + mimeType.toString());
        }
        if (converters.size() > 1) {
            return new CompositeMessageConverter(converters);
        }
        return (MessageConverter)converters.get(0);
    }

    public CompositeMessageConverter getMessageConverterForAllRegistered() {
        return new CompositeMessageConverter(new ArrayList<MessageConverter>(this.converters));
    }
}

