/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.stream.channel;

import cn.com.duibaboot.ext.stream.support.TopicOperater;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHandler;
import org.springframework.messaging.support.AbstractMessageChannel;

public class ProducerMessageChannel
extends AbstractMessageChannel {
    private static final Logger log = LoggerFactory.getLogger(ProducerMessageChannel.class);
    private MessageHandler messageHandler;

    protected boolean sendInternal(@NotNull Message<?> message, long timeout) {
        try {
            if (Objects.isNull(this.messageHandler)) {
                log.warn("\u672a\u6ce8\u5165messageHandler,\u65e0\u6cd5\u53d1\u9001\u6d88\u606f");
                throw new RuntimeException("\u672a\u6ce8\u5165messageHandler,\u65e0\u6cd5\u53d1\u9001\u6d88\u606f");
            }
            String topic = TopicOperater.findTopic(message);
            if (StringUtils.isBlank((CharSequence)topic)) {
                throw new RuntimeException("\u6d88\u606f\u5934\u7f3a\u4e4fTopic");
            }
            this.messageHandler.handleMessage(message);
            return true;
        }
        catch (Exception e) {
            log.error("stream\u6d88\u606f\u53d1\u9001\u5931\u8d25", (Throwable)e);
            return false;
        }
    }

    public void setMessageHandler(MessageHandler messageHandler) {
        this.messageHandler = messageHandler;
    }
}

