/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.stream.binding;

import cn.com.duibaboot.ext.stream.binding.StreamListenerMessageHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.integration.handler.AbstractReplyProducingMessageHandler;
import org.springframework.messaging.Message;
import org.springframework.util.Assert;

final class DispatchingStreamListenerMessageHandler
extends AbstractReplyProducingMessageHandler {
    private final List<ConditionalStreamListenerMessageHandlerWrapper> handlerMethods;
    private final boolean evaluateExpressions;
    private final EvaluationContext evaluationContext;

    DispatchingStreamListenerMessageHandler(Collection<ConditionalStreamListenerMessageHandlerWrapper> handlerMethods, EvaluationContext evaluationContext) {
        Assert.notEmpty(handlerMethods, (String)"'handlerMethods' cannot be empty");
        this.handlerMethods = Collections.unmodifiableList(new ArrayList<ConditionalStreamListenerMessageHandlerWrapper>(handlerMethods));
        boolean evaluateExpressions = false;
        for (ConditionalStreamListenerMessageHandlerWrapper handlerMethod : handlerMethods) {
            if (handlerMethod.getCondition() == null) continue;
            evaluateExpressions = true;
            break;
        }
        this.evaluateExpressions = evaluateExpressions;
        if (evaluateExpressions) {
            Assert.notNull((Object)evaluationContext, (String)"'evaluationContext' cannot be null if conditions are used");
        }
        this.evaluationContext = evaluationContext;
    }

    protected boolean shouldCopyRequestHeaders() {
        return false;
    }

    protected Object handleRequestMessage(Message<?> requestMessage) {
        List<ConditionalStreamListenerMessageHandlerWrapper> matchingHandlers;
        List<ConditionalStreamListenerMessageHandlerWrapper> list = matchingHandlers = this.evaluateExpressions ? this.findMatchingHandlers(requestMessage) : this.handlerMethods;
        if (matchingHandlers.size() == 0) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn((Object)("Cannot find a @StreamListener matching for message with id: " + requestMessage.getHeaders().getId()));
            }
            return null;
        }
        if (matchingHandlers.size() > 1) {
            for (ConditionalStreamListenerMessageHandlerWrapper matchingMethod : matchingHandlers) {
                matchingMethod.getStreamListenerMessageHandler().handleMessage(requestMessage);
            }
            return null;
        }
        ConditionalStreamListenerMessageHandlerWrapper singleMatchingHandler = matchingHandlers.get(0);
        singleMatchingHandler.getStreamListenerMessageHandler().handleMessage(requestMessage);
        return null;
    }

    private List<ConditionalStreamListenerMessageHandlerWrapper> findMatchingHandlers(Message<?> message) {
        ArrayList<ConditionalStreamListenerMessageHandlerWrapper> matchingMethods = new ArrayList<ConditionalStreamListenerMessageHandlerWrapper>();
        for (ConditionalStreamListenerMessageHandlerWrapper wrapper : this.handlerMethods) {
            if (wrapper.getCondition() == null) {
                matchingMethods.add(wrapper);
                continue;
            }
            boolean conditionMetOnMessage = (Boolean)wrapper.getCondition().getValue(this.evaluationContext, message, Boolean.class);
            if (!conditionMetOnMessage) continue;
            matchingMethods.add(wrapper);
        }
        return matchingMethods;
    }

    static class ConditionalStreamListenerMessageHandlerWrapper {
        private final Expression condition;
        private final StreamListenerMessageHandler streamListenerMessageHandler;

        ConditionalStreamListenerMessageHandlerWrapper(Expression condition, StreamListenerMessageHandler streamListenerMessageHandler) {
            Assert.notNull((Object)((Object)streamListenerMessageHandler), (String)"the message handler cannot be null");
            Assert.isTrue((condition == null || streamListenerMessageHandler.isVoid() ? 1 : 0) != 0, (String)"cannot specify a condition and a return value at the same time");
            this.condition = condition;
            this.streamListenerMessageHandler = streamListenerMessageHandler;
        }

        public Expression getCondition() {
            return this.condition;
        }

        public boolean isVoid() {
            return this.streamListenerMessageHandler.isVoid();
        }

        public StreamListenerMessageHandler getStreamListenerMessageHandler() {
            return this.streamListenerMessageHandler;
        }
    }
}

