/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.buried.point.sdk;

import cn.com.duiba.buried.point.sdk.ILog;
import cn.com.duiba.buried.point.sdk.bean.Event;
import cn.com.duiba.buried.point.sdk.bean.SuperProperties;
import cn.com.duiba.buried.point.sdk.consumer.Consumer;
import cn.com.duiba.buried.point.sdk.exceptions.InvalidArgumentException;
import cn.com.duiba.buried.point.sdk.utils.AnalyticsUtil;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadLocalRandom;

public class Log
implements ILog {
    private final Consumer consumer;
    private final Map<String, Object> superProperties;

    public Log(Consumer consumer) {
        this.consumer = consumer;
        this.superProperties = new ConcurrentHashMap<String, Object>();
        this.clearSuperProperties();
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

            @Override
            public void run() {
                Log.this.flush();
            }
        }));
    }

    @Override
    public void registerSuperProperties(SuperProperties superProperties) {
        for (String key : superProperties.getPropertyMap().keySet()) {
            this.superProperties.put(key, superProperties.getPropertyMap().get(key));
        }
    }

    @Override
    public void clearSuperProperties() {
        this.superProperties.clear();
        this.superProperties.put("$lib", "Java");
        this.superProperties.put("$lib_version", "1.0.0");
    }

    @Override
    public void track(Event event) throws InvalidArgumentException {
        this.addEvent(event.getDistinctId(), event.getIsLogin(), null, "track", event.getEventName(), event.getPropertyMap());
    }

    @Override
    public void flush() {
        this.consumer.flush();
    }

    @Override
    public void shutdown() {
        this.consumer.close();
    }

    private void addEvent(String distinctId, boolean isLogin, String originDistinctId, String actionType, String eventName, Map<String, Object> properties) throws InvalidArgumentException {
        AnalyticsUtil.assertValue("Distinct Id", distinctId);
        AnalyticsUtil.assertProperties(actionType, properties);
        if (actionType.equals("track")) {
            AnalyticsUtil.assertKey("Event Name", eventName);
        } else if (actionType.equals("track_signup")) {
            AnalyticsUtil.assertValue("Original Distinct Id", originDistinctId);
        }
        long time = System.currentTimeMillis();
        HashMap<String, Object> newProperties = null;
        if (properties != null) {
            newProperties = new HashMap<String, Object>(properties);
        }
        if (newProperties != null && newProperties.containsKey("$time")) {
            Date eventTime = (Date)newProperties.get("$time");
            newProperties.remove("$time");
            time = eventTime.getTime();
        }
        String eventProject = null;
        String eventToken = null;
        if (newProperties != null) {
            if (newProperties.containsKey("$project")) {
                eventProject = (String)newProperties.get("$project");
                newProperties.remove("$project");
            }
            if (newProperties.containsKey("$token")) {
                eventToken = (String)newProperties.get("$token");
                newProperties.remove("$token");
            }
        }
        HashMap<String, Object> eventProperties = new HashMap<String, Object>();
        if (actionType.equals("track") || actionType.equals("track_signup")) {
            eventProperties.putAll(this.superProperties);
        }
        if (newProperties != null) {
            eventProperties.putAll(newProperties);
        }
        if (isLogin) {
            eventProperties.put("$is_login", true);
        }
        Map<String, String> libProperties = this.getLibProperties();
        HashMap<String, Object> event = new HashMap<String, Object>();
        event.put("type", actionType);
        event.put("time", time);
        event.put("distinct_id", distinctId);
        event.put("properties", eventProperties);
        event.put("lib", libProperties);
        event.put("_track_id", ThreadLocalRandom.current().nextInt());
        if (eventProject != null) {
            event.put("project", eventProject);
        }
        if (eventToken != null) {
            event.put("token", eventToken);
        }
        if (actionType.equals("track")) {
            event.put("event", eventName);
        } else if (actionType.equals("track_signup")) {
            event.put("event", eventName);
            event.put("original_id", originDistinctId);
        }
        this.consumer.send(event);
    }

    private Map<String, String> getLibProperties() {
        StackTraceElement[] trace;
        HashMap<String, String> libProperties = new HashMap<String, String>();
        libProperties.put("$lib", "Java");
        libProperties.put("$lib_version", "1.0.0");
        libProperties.put("$lib_method", "code");
        if (this.superProperties.containsKey("$app_version")) {
            libProperties.put("$app_version", (String)this.superProperties.get("$app_version"));
        }
        if ((trace = new Exception().getStackTrace()).length > 3) {
            StackTraceElement traceElement = trace[3];
            libProperties.put("$lib_detail", String.format("%s##%s##%s##%s", traceElement.getClassName(), traceElement.getMethodName(), traceElement.getFileName(), traceElement.getLineNumber()));
        }
        return libProperties;
    }
}

