/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.buried.point.sdk.bean;

import cn.com.duiba.buried.point.sdk.exceptions.InvalidArgumentException;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Event
implements Serializable {
    private static final long serialVersionUID = -2327319579147636283L;
    private final Map<String, Object> propertyMap;
    private final String eventName;
    private final String distinctId;
    private final Boolean isLogin;

    private Event(String eventName, String distinctId, Boolean isLogin, Map<String, Object> propertyMap) {
        this.eventName = eventName;
        this.distinctId = distinctId;
        this.isLogin = isLogin;
        this.propertyMap = propertyMap;
    }

    public String toString() {
        return "EventRecord{propertyMap=" + this.propertyMap + ", eventName='" + this.eventName + '\'' + ", distinctId='" + this.distinctId + '\'' + ", isLogin='" + this.isLogin + '\'' + '}';
    }

    public static Builder builder() {
        return new Builder();
    }

    public Map<String, Object> getPropertyMap() {
        return this.propertyMap;
    }

    public String getEventName() {
        return this.eventName;
    }

    public String getDistinctId() {
        return this.distinctId;
    }

    public Boolean getIsLogin() {
        return this.isLogin;
    }

    public static class Builder {
        private Map<String, Object> propertyMap = new HashMap<String, Object>();
        private String eventName;
        private String distinctId;
        private Boolean isLogin;

        private Builder() {
        }

        public Event build() throws InvalidArgumentException {
            if (this.eventName == null) {
                throw new InvalidArgumentException("The eventName is empty.");
            }
            if (this.distinctId == null) {
                throw new InvalidArgumentException("The distinctId is empty.");
            }
            if (this.isLogin == null) {
                throw new InvalidArgumentException("The isLogin is empty.");
            }
            return new Event(this.eventName, this.distinctId, this.isLogin, this.propertyMap);
        }

        public Builder setEventName(String eventName) {
            this.eventName = eventName;
            return this;
        }

        public Builder setDistinctId(String distinctId) {
            this.distinctId = distinctId;
            return this;
        }

        public Builder isLogin(Boolean login) {
            this.isLogin = login;
            return this;
        }

        public Builder addProperties(Map<String, Object> properties) {
            if (properties != null) {
                this.propertyMap.putAll(properties);
            }
            return this;
        }

        public Builder addProperty(String key, String property) {
            this.addPropertyObject(key, property);
            return this;
        }

        public Builder addProperty(String key, boolean property) {
            this.addPropertyObject(key, property);
            return this;
        }

        public Builder addProperty(String key, Number property) {
            this.addPropertyObject(key, property);
            return this;
        }

        public Builder addProperty(String key, Date property) {
            this.addPropertyObject(key, property);
            return this;
        }

        public Builder addProperty(String key, List<String> property) {
            this.addPropertyObject(key, property);
            return this;
        }

        private void addPropertyObject(String key, Object property) {
            if (key != null) {
                this.propertyMap.put(key, property);
            }
        }
    }
}

