/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.buried.point.sdk.bean;

import cn.com.duiba.buried.point.sdk.exceptions.InvalidArgumentException;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class User
implements Serializable {
    private static final long serialVersionUID = -6661580072748171679L;
    private final Map<String, Object> propertyMap;
    private final String distinctId;
    private final Boolean isLogin;

    private User(Map<String, Object> propertyMap, String distinctId, Boolean isLogin) {
        this.propertyMap = propertyMap;
        this.distinctId = distinctId;
        this.isLogin = isLogin;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getDistinctId() {
        return this.distinctId;
    }

    public Boolean getIsLogin() {
        return this.isLogin;
    }

    public Map<String, Object> getPropertyMap() {
        return this.propertyMap;
    }

    public static class Builder {
        private Map<String, Object> propertyMap = new HashMap<String, Object>();
        private String distinctId;
        private Boolean isLogin;

        private Builder() {
        }

        public User build() throws InvalidArgumentException {
            if (this.distinctId == null) {
                throw new InvalidArgumentException("The distinctId is empty.");
            }
            if (this.isLogin == null) {
                throw new InvalidArgumentException("The isLogin is empty.");
            }
            return new User(this.propertyMap, this.distinctId, this.isLogin);
        }

        public Builder setDistinctId(String distinctId) {
            this.distinctId = distinctId;
            return this;
        }

        public Builder isLogin(Boolean login) {
            this.isLogin = login;
            return this;
        }

        public Builder addProperties(Map<String, Object> properties) {
            if (properties != null) {
                this.propertyMap.putAll(properties);
            }
            return this;
        }

        public Builder addProperty(String key, String property) {
            this.addPropertyObject(key, property);
            return this;
        }

        public Builder addProperty(String key, boolean property) {
            this.addPropertyObject(key, property);
            return this;
        }

        public Builder addProperty(String key, Number property) {
            this.addPropertyObject(key, property);
            return this;
        }

        public Builder addProperty(String key, Date property) {
            this.addPropertyObject(key, property);
            return this;
        }

        public Builder addProperty(String key, List<String> property) {
            this.addPropertyObject(key, property);
            return this;
        }

        private void addPropertyObject(String key, Object property) {
            if (key != null) {
                this.propertyMap.put(key, property);
            }
        }
    }
}

