/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.buried.point.sdk.consumer;

import cn.com.duiba.buried.point.sdk.consumer.Consumer;
import cn.com.duiba.buried.point.sdk.utils.AnalyticsUtil;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TempLogbackConsumer
implements Consumer {
    private Logger logger = LoggerFactory.getLogger(TempLogbackConsumer.class);
    private static final int BUFFER_LIMITATION = 0x40000000;
    private final ObjectMapper jsonMapper = AnalyticsUtil.getJsonObjectMapper();
    private final StringBuilder messageBuffer;
    private final int bufferSize;

    public TempLogbackConsumer(int bufferSize) {
        this.messageBuffer = new StringBuilder(bufferSize);
        this.bufferSize = bufferSize;
    }

    @Override
    public synchronized void send(Map<String, Object> message) {
        if (this.messageBuffer.length() < 0x40000000) {
            try {
                this.messageBuffer.append(this.jsonMapper.writeValueAsString(message));
                this.messageBuffer.append("\n");
            }
            catch (JsonProcessingException e) {
                throw new RuntimeException("fail to process json", e);
            }
        } else {
            throw new RuntimeException("logging buffer exceeded the allowed limitation.");
        }
        if (this.messageBuffer.length() >= this.bufferSize) {
            this.flush();
        }
    }

    @Override
    public synchronized void flush() {
        if (this.messageBuffer.length() == 0) {
            return;
        }
        this.logger.info(this.messageBuffer.toString());
        this.messageBuffer.setLength(0);
    }

    @Override
    public synchronized void close() {
        this.flush();
    }
}

