/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.buried.point.sdk.utils;

import cn.com.duiba.buried.point.sdk.exceptions.InvalidArgumentException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.regex.Pattern;

public class AnalyticsUtil {
    private static final Pattern KEY_PATTERN = Pattern.compile("^((?!^distinct_id$|^original_id$|^time$|^properties$|^id$|^first_id$|^second_id$|^users$|^events$|^event$|^user_id$|^date$|^datetime$|^user_group|^user_tag)[a-zA-Z_$][a-zA-Z\\d_$]{0,99})$", 2);

    public static String strJoin(String[] arr, String sep) {
        StringBuilder sbStr = new StringBuilder();
        int il = arr.length;
        for (int i = 0; i < il; ++i) {
            if (i > 0) {
                sbStr.append(sep);
            }
            sbStr.append(arr[i]);
        }
        return sbStr.toString();
    }

    public static ObjectMapper getJsonObjectMapper() {
        ObjectMapper jsonObjectMapper = new ObjectMapper();
        jsonObjectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        jsonObjectMapper.setPropertyNamingStrategy(PropertyNamingStrategy.CAMEL_CASE_TO_LOWER_CASE_WITH_UNDERSCORES);
        jsonObjectMapper.setTimeZone(TimeZone.getDefault());
        jsonObjectMapper.setDateFormat((DateFormat)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS"));
        return jsonObjectMapper;
    }

    public static void assertProperties(String eventType, Map<String, Object> properties) throws InvalidArgumentException {
        if (null == properties) {
            return;
        }
        for (Map.Entry<String, Object> property : properties.entrySet()) {
            String value;
            if (property.getKey().equals("$is_login")) {
                if (property.getValue() instanceof Boolean) continue;
                throw new InvalidArgumentException("The property value of '$is_login_id' should be Boolean.");
            }
            AnalyticsUtil.assertKey("property", property.getKey());
            if (!(property.getValue() instanceof Number || property.getValue() instanceof Date || property.getValue() instanceof String || property.getValue() instanceof Boolean || property.getValue() instanceof List)) {
                throw new InvalidArgumentException("The property '" + property.getKey() + "' should be a basic type: Number, String, Date, Boolean, List<String>.");
            }
            if (property.getKey().equals("$time") && !(property.getValue() instanceof Date)) {
                throw new InvalidArgumentException("The property '$time' should be a java.util.Date.");
            }
            if (!(property.getValue() instanceof String) || (value = (String)property.getValue()).length() <= 8192) continue;
            property.setValue(value.substring(0, 8192));
        }
    }

    public static void assertValue(String type, String value) throws InvalidArgumentException {
        if (value == null || value.length() < 1) {
            throw new InvalidArgumentException("The value is empty or null.");
        }
        if (value.length() > 255) {
            throw new InvalidArgumentException("The " + type + " value '" + value + "' is too long, max length is 255.");
        }
    }

    public static void assertKey(String type, String key) throws InvalidArgumentException {
        if (null == key || key.length() < 1) {
            throw new InvalidArgumentException("The key is empty or null.");
        }
    }
}

