package cn.com.duiba.cloud.delay.client;

import cn.com.duiba.wolf.entity.JsonResult;

import java.util.concurrent.TimeUnit;

/**
 * 延迟消息客户端
 *
 * @author zouweixiang
 * @date 2021/11/16
 */
public interface DelayMessageClient {

    /**
     * 延迟发送消息
     *
     * @param bizType  业务类型
     * @param bizNo    业务标识
     * @param fireTime 点火时间，需要回调发送消息的时间
     * @param timeUnit 时间单位
     * @return {@link JsonResult<String>}
     */
    JsonResult<String> sendDelayMessage(String bizType, String bizNo, Integer fireTime, TimeUnit timeUnit);
}
