package cn.com.duiba.cloud.delay.client.consumer;

import cn.com.duiba.cloud.delay.client.BaseDelayMessageCallBack;
import cn.com.duiba.cloud.delay.client.model.DelayMessageParam;
import com.alibaba.fastjson.JSON;
import com.google.common.collect.Maps;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.StringUtils;
import org.apache.rocketmq.spring.annotation.MessageModel;
import org.apache.rocketmq.spring.annotation.RocketMQMessageListener;
import org.apache.rocketmq.spring.core.RocketMQListener;
import org.springframework.context.ApplicationContext;
import org.springframework.util.CollectionUtils;

import javax.annotation.Resource;
import java.util.Map;

/**
 * 延迟消息使用方
 *
 * @author zouweixiang
 * @date 2021/11/15
 */
@Slf4j
@RocketMQMessageListener(
        topic = "${duiba.cloud.delay-engine.mq.topic}",
        selectorExpression = "${spring.application.name}",
        consumerGroup = "${spring.application.name}" + "-delay",
        nameServer = "${duiba.cloud.delay-engine.mq.nameserver}",
        messageModel = MessageModel.CLUSTERING
)
public class DelayMessageConsumer implements RocketMQListener<String> {

    /**
     * 消息客户端接口MAP
     */
    public static Map<String, BaseDelayMessageCallBack> messageClientMap = Maps.newHashMap();

    @Resource
    private ApplicationContext applicationContext;

    @Override
    public void onMessage(String message) {
        if (StringUtils.isBlank(message)) {
            log.error("DelayMessageConsumer 延迟消息为空，消费失败");
            return;
        }
        DelayMessageParam delayMessageParam = JSON.parseObject(message, DelayMessageParam.class);
        if (CollectionUtils.isEmpty(messageClientMap)) {
            log.warn("DelayMessageConsumer 没有配置监听者,bizNo:{},bizType:{}", delayMessageParam.getBizNo(), delayMessageParam.getBizType());
            return;
        }
        try {
            messageClientMap.get(delayMessageParam.getBizType()).consumerMessage(delayMessageParam.getBizNo());
        } catch (Exception e) {
            log.error("DelayMessageConsumer 延迟消息消费失败，bizNo:{},bizType:{}", delayMessageParam.getBizNo(), delayMessageParam.getBizType(), e);
        }
    }


    /**
     * 初始化
     */
    public void init() {
        Map<String, BaseDelayMessageCallBack> beansOfType = applicationContext.getBeansOfType(BaseDelayMessageCallBack.class);
        beansOfType.forEach((k,v) -> {
            // 汇总到map
            DelayMessageConsumer.messageClientMap.put(v.settingBizType(), v);
        });
    }
}
