package cn.com.duiba.cloud.delay.client.service;

import cn.com.duiba.cloud.delay.client.DelayMessageClient;
import cn.com.duiba.cloud.delay.client.model.DelayMessageParam;
import cn.com.duiba.cloud.delay.client.remoteservice.DelayMessageRemoteService;
import cn.com.duiba.wolf.entity.JsonResult;
import cn.hutool.core.date.DateField;
import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.StrUtil;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Value;

import javax.annotation.Resource;
import java.util.Date;
import java.util.concurrent.TimeUnit;

/**
 * 延迟消息客户端impl
 *
 * @author zouweixiang
 * @date 2021/11/16
 */
@Slf4j
public class DelayMessageClientImpl implements DelayMessageClient {

    @Value("${spring.application.name}")
    private String appId;

    @Resource
    private DelayMessageRemoteService delayMessageRemoteService;

    private static final Integer RETRY = 5;

    @Override
    public JsonResult<String> sendDelayMessage(String bizType, String bizNo, Integer fireTime, TimeUnit timeUnit) {
        // 计算点火时间
        long fireSeconds = timeUnit.toSeconds(fireTime);
        DateTime offset = DateUtil.offset(new Date(), DateField.SECOND, (int) fireSeconds);
        Date fireDate = new Date(offset.getTime());
        DelayMessageParam delayMessageParam = DelayMessageParam.builder()
                .appId(appId)
                .bizNo(bizNo)
                .bizType(bizType)
                .fireTime(fireDate).build();
        try {
            String stringJsonResult = delayMessageRemoteService.sendDelayMessage(delayMessageParam);
            if (StrUtil.isBlank(stringJsonResult)) {
                log.warn("DelayMessageClientImpl 调用延时引擎失败:bizType:{},bizNo:{},msg:{}", bizType, bizNo, stringJsonResult);
            }
        } catch (Exception e) {
            log.error("DelayMessageClientImpl 调用延时引擎失败重试:bizType:{},bizNo:{}", bizType, bizNo, e);
            throw e;
        }
        return JsonResult.success();
    }


}
