/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.cloud.delay.client.consumer;

import cn.com.duiba.cloud.delay.client.BaseDelayMessageCallBack;
import cn.com.duiba.cloud.delay.client.model.DelayMessageParam;
import com.alibaba.fastjson.JSON;
import com.google.common.collect.Maps;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.apache.rocketmq.spring.annotation.MessageModel;
import org.apache.rocketmq.spring.annotation.RocketMQMessageListener;
import org.apache.rocketmq.spring.core.RocketMQListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.util.CollectionUtils;

@RocketMQMessageListener(topic="${duiba.cloud.delay-engine.mq.topic}", selectorExpression="${spring.application.name}", consumerGroup="${spring.application.name}-delay", nameServer="${duiba.cloud.delay-engine.mq.nameserver}", messageModel=MessageModel.CLUSTERING)
public class DelayMessageConsumer
implements RocketMQListener<String> {
    private static final Logger log = LoggerFactory.getLogger(DelayMessageConsumer.class);
    public static Map<String, BaseDelayMessageCallBack> messageClientMap = Maps.newHashMap();
    @Resource
    private ApplicationContext applicationContext;

    public void onMessage(String message) {
        if (StringUtils.isBlank((String)message)) {
            log.error("DelayMessageConsumer \u5ef6\u8fdf\u6d88\u606f\u4e3a\u7a7a\uff0c\u6d88\u8d39\u5931\u8d25");
            return;
        }
        DelayMessageParam delayMessageParam = (DelayMessageParam)JSON.parseObject((String)message, DelayMessageParam.class);
        if (CollectionUtils.isEmpty(messageClientMap)) {
            log.warn("DelayMessageConsumer \u6ca1\u6709\u914d\u7f6e\u76d1\u542c\u8005,bizNo:{},bizType:{}", (Object)delayMessageParam.getBizNo(), (Object)delayMessageParam.getBizType());
            return;
        }
        try {
            messageClientMap.get(delayMessageParam.getBizType()).consumerMessage(delayMessageParam.getBizNo());
        }
        catch (Exception e) {
            log.error("DelayMessageConsumer \u5ef6\u8fdf\u6d88\u606f\u6d88\u8d39\u5931\u8d25\uff0cbizNo:{},bizType:{}", new Object[]{delayMessageParam.getBizNo(), delayMessageParam.getBizType(), e});
        }
    }

    public void init() {
        Map beansOfType = this.applicationContext.getBeansOfType(BaseDelayMessageCallBack.class);
        beansOfType.forEach((k, v) -> messageClientMap.put(v.settingBizType(), (BaseDelayMessageCallBack)v));
    }
}

