/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.cloud.delay.client.service;

import cn.com.duiba.cloud.delay.client.DelayMessageClient;
import cn.com.duiba.cloud.delay.client.model.DelayMessageParam;
import cn.com.duiba.cloud.delay.client.remoteservice.DelayMessageRemoteService;
import cn.com.duiba.wolf.entity.JsonResult;
import cn.hutool.core.date.DateField;
import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.StrUtil;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;

public class DelayMessageClientImpl
implements DelayMessageClient {
    private static final Logger log = LoggerFactory.getLogger(DelayMessageClientImpl.class);
    @Value(value="${spring.application.name}")
    private String appId;
    @Resource
    private DelayMessageRemoteService delayMessageRemoteService;
    private static final Integer RETRY = 5;

    @Override
    public JsonResult<String> sendDelayMessage(String bizType, String bizNo, Integer fireTime, TimeUnit timeUnit) {
        long fireSeconds = timeUnit.toSeconds(fireTime.intValue());
        DateTime offset = DateUtil.offset((Date)new Date(), (DateField)DateField.SECOND, (int)((int)fireSeconds));
        Date fireDate = new Date(offset.getTime());
        DelayMessageParam delayMessageParam = DelayMessageParam.builder().appId(this.appId).bizNo(bizNo).bizType(bizType).fireTime(fireDate).build();
        try {
            String stringJsonResult = this.delayMessageRemoteService.sendDelayMessage(delayMessageParam);
            if (StrUtil.isBlank((CharSequence)stringJsonResult)) {
                log.warn("DelayMessageClientImpl \u8c03\u7528\u5ef6\u65f6\u5f15\u64ce\u5931\u8d25:bizType:{},bizNo:{},msg:{}", new Object[]{bizType, bizNo, stringJsonResult});
            }
        }
        catch (Exception e) {
            log.error("DelayMessageClientImpl \u8c03\u7528\u5ef6\u65f6\u5f15\u64ce\u5931\u8d25\u91cd\u8bd5:bizType:{},bizNo:{}", new Object[]{bizType, bizNo, e});
            throw e;
        }
        return JsonResult.success();
    }
}

