package cn.com.duiba.cloud.duiba.activity.service.api.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * @date:2022/3/29 10:01
 * @author:zhaozhanghai
 * @Description: 活动玩法配置枚举
 */
@AllArgsConstructor
@Getter
public enum PlayConfigEnum {
    //地区限制
    district_limit_no(1,"地区限制 1-不限制"),
    district_limit_join(2,"地区限制 2-指定地区可参与"),
    district_limit_unjoin(3,"地区限制 3-指定地区不可参与"),

    //用户身份限制
    identity_limit_no(1,"用户身份限制 1-不限制"),
    identity_limit_join(2,"用户身份限制 2-指定用户可参与"),
    identity_limit_unjoin(3,"用户身份限制 3-指定用户不可参与"),

    //多奖项中奖限制-单位
    more_prize_unit_day(1,"多奖项中奖限制-单位 1每日"),
    more_prize_unit_week(2,"多奖项中奖限制-单位 2每周"),
    more_prize_unit_month(3,"多奖项中奖限制-单位 3每月"),
    more_prize_unit_custom(4,"多奖项中奖限制-单位 4自定义天"),


    //参与次数限制单位 参与免费次数单位
    join_limit_unit_day(1,"参与次数限制单位  1-次/每天"),
    join_limit_unit_forever(2,"参与次数限制单位  2-次/永久"),

    ;


    private Integer type;
    private String desc;

}
