package cn.com.duiba.cloud.duiba.activity.service.api.exception;


import java.util.Objects;

/**
 * @ClassName ErrorMeta
 * @Description 错误对象
 * @Author zhoujunquan@duiba.com.cn
 * @Date 2021/8/12 1:43 下午
 * @Version 1.0
 **/
public class ErrorMeta implements Error<String> {
    private String code;
    private String desc;

    public ErrorMeta(String code, String desc) {
        super();
        Objects.requireNonNull(code, "code不能为null");
        Objects.requireNonNull(desc, "desc不能为null");
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String getDesc() {
        return desc;
    }

    @Override
    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    /**
     * 返回exception，并且附带数据，默认info级别
     *
     * @param data 数据
     * @return 返回exception
     */
    public ApiException getExceptionData(Object data) {
        ApiException ex = this.getException();
        ex.setData(data);
        return ex;
    }

    /**
     * 返回exception，并且附带数据
     *
     * @param data       数据
     * @param outWarnLog 是否需要warn日志输出
     * @return 返回exception
     */
    public ApiException getExceptionData(Object data, boolean outWarnLog) {
        ApiException ex = this.getException(outWarnLog);
        ex.setData(data);
        return ex;
    }

    /**
     * 默认info级别输出，不附带数据
     *
     * @return 返回exception
     */
    public ApiException getException() {
        return this.getDefaultException();
    }

    /**
     * 指定是否需要warn日志输出
     *
     * @param outWarnLog 是否需要warn日志输出
     * @return 返回exception
     */
    public ApiException getException(boolean outWarnLog) {
        ApiException ex = this.getDefaultException();
        ex.setOutWarnLog(outWarnLog);
        return ex;
    }

    private ApiException getDefaultException() {
        Error<String> error = new Error<String>() {
            @Override
            public String getDesc() {
                return desc;
            }

            @Override
            public String getCode() {
                return code;
            }
        };
        return new ApiException(error);
    }
}