package cn.com.duiba.cloud.duiba.activity.service.api.jsonparse.config;

import lombok.Data;

import java.io.Serializable;

/**
 * @date:2022/3/25 09:46
 * @author:zhaozhanghai
 * @Description: 活动基础配置
 */
@Data
public class BaseConfig  implements Serializable {
    /**
     * 活动标题
     */
    private String title;

    /**
     * 活动规则描述
     */
    private String activityRule;

    /**
     * 活动开始时间
     */
    private String beginTime;

    /**
     * 活动结束时间
     */
    private String endTime;

    /**
     * 是否支持积分参与 0-不支持 1-支持
     */
    private Integer isSupportCredits;

    /**
     * 是否开启浮标 0-不开启 1-开启
     */
    private Integer isOpenBuoy;

    /**
     * 浮标位置 1-左侧 2-右侧
     */
    private Integer buoyPosition;

    /**
     * 浮标距离顶部位置px
     */
    private Integer buoyTopPx;

    /**
     * 浮标图片
     */
    private String buoyImage;

    /**
     * 浮标跳转链接
     */
    private String buoyLink;

    /**
     * 入口图
     */
    private String banner;
}
