package cn.com.duiba.cloud.duiba.activity.service.api.jsonparse.config;

import lombok.Data;

import java.io.Serializable;

/**
 * @date:2022/3/25 09:46
 * @author:zhaozhanghai
 * @Description: 活动概率出奖玩法配置
 */
@Data
public class PlayConfig implements Serializable {


    /**
     * 地区限制 1-不限制 2-指定地区可参与 3-指定地区不可参与
     */
    private Integer districtLimit;

    /**
     * 用户身份限制 1-不限制 2-指定用户可参与 3-指定用户不可参与
     */
    private Integer identityLimit;

    /**
     * 用户身份限制 身份信息 [等级1，等级2，等级3]
     */
    private String identityLimitLevel;

    /**
     * 参与积分
     */
    private Integer joinCredits;

    /**
     * 参与次数限制
     */
    private Integer joinLimit;

    /**
     * 参与次数限制单位 1-次/每天 2-次/永久
     */
    private Integer joinLimitUnit;

    /**
     * 参与免费次数
     */
    private Integer joinFreeLimit;

    /**
     * 参与免费次数单位 1-次/每天 2-次/永久
     */
    private Integer joinFreeLimitUnit;



    /**
     * 用户分层参与 0-不开启 1-开启
     */
    private Integer isIdentityLayeredJoin;

    /**
     * 用户分层出奖 0-不开启 1-开启
     */
    private Integer isIdentityLayeredPrize;

    /**
     * 多奖项中奖限制开启 0-不开启 1-开启
     */
    private Integer isMorePrize;

    /**
     * 多奖项中奖限制-次
     */
    private Integer morePrizeTimes;

    /**
     * 多奖项中奖限制-单位 1-每日 2-每周 3-每月 4-自定义天
     */
    private Integer morePrizeUnit;

    /**
     * 多奖项中奖限制-单位-自定义天数
     */
    private Integer morePrizeUnitDay;

    /**
     * 百分百中奖开启 0-不开启 1-开启
     */
    private Integer absolutelyPrize;
}
