package cn.com.duiba.cloud.duiba.activity.service.api.remoteservice.activity;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.cloud.duiba.activity.service.api.dto.activity.MallActivityDTO;
import cn.com.duiba.cloud.duiba.activity.service.api.dto.activity.MallActivityRulePrizeDTO;

import java.util.List;


/**
 * 活动奖品服务
 */
@AdvancedFeignClient
public interface RemoteActivityRulePrizeService {

    /**
     * 获取活动奖品
     * @param activityId
     * @return
     */
    List<MallActivityRulePrizeDTO> listByActivityId(Long activityId);

    /**
     * 批量保存
     * @param dtos
     * @return
     */
    Boolean saveBatch(List<MallActivityRulePrizeDTO> dtos);

    /**
     * 批量更新
     * @param dtos
     * @return
     */
    Boolean updateBatchById(List<MallActivityRulePrizeDTO> dtos);

    /**
     * 设置奖品可用库存
     * @param prizeId
     * @param totalStock
     * @return
     */
    Boolean updateTotalStock(Long prizeId, Long totalStock) throws BizException;








}
