package cn.com.duiba.cloud.duiba.activity.service.api.remoteservice.playways.join;

import cn.com.duiba.cloud.duiba.activity.service.api.dto.PlaywayActionRecordDTO;

import java.util.Date;
import java.util.List;

/**
 * 参与玩法API
 * 1.用户请求参与玩法的接口时，自定义代码区域可使用此API
 */
public interface JoinUserRequestApi {

    /**
     * 查询我的今日参与次数
     *
     * @return 用户当前活动今日的参与次数
     * @desc ⚠️ 该处参与不单指dojoin
     */
    Long queryMyTodayCount(Long activityId, String scene, Long cid);

    /**
     * 查询我连续参与的天数
     * 最多不超过100天
     *
     * @return 连续参与天数
     */
    Integer queryMyContinueDays(Long activityId, String scene, Long cid);

    /**
     * 查询我的永久参与次数
     *
     * @return 用户当前活动的所有参与次数
     */
    Long queryMyAllCount(Long activityId, String scene, Long cid);

    /**
     * 查询我最近的参与记录
     *
     * @param limit
     * @return
     */
    List<PlaywayActionRecordDTO> queryMyRecentRecord(Long activityId, String scene, Long cid, int limit);

    /**
     * 查询我的参与记录
     *
     * @param start
     * @param end
     * @return
     */
    List<PlaywayActionRecordDTO> queryMyRecords(Long activityId, String scene, Long cid, Date start, Date end);

}
