package cn.com.duiba.cloud.duiba.activity.service.api.enums;

import org.apache.commons.lang.StringUtils;

public enum PlaywayEnum {

    CREDITS(0,"扣积分"),

    JOIN(1, "参与玩法"),

    SCORING(2, "计分玩法"),

    INVITE(3,"邀请玩法"),

    ASSIST(4,"助力玩法"),

    LUCKYCODE(5,"幸运码"),

    PET(6, "养成玩法"),

    SIGN(7, "签到"),



    share(100, "分享组件玩法"),

    exchange(101, "兑换组件玩法"),

    inviteAssist(102, "邀请助力组件玩法"),

    period(103, "有效期组件玩法"),

    rank(104, "排行榜组件玩法"),

    checkin(105, "签到组件玩法"),

    countdown(106, "倒计时组件玩法"),

    bindPhone(107, "手机号绑定组件玩法"),

    grade(108, "等级组件玩法"),

    task(109, "任务组件玩法"),

    newGuide(110, "新手引导组件玩法"),

    collectSp(111, "新手引导组件玩法"),

    carousel(112, "轮播组件玩法"),

    drawPrize(113, "抽奖组件玩法"),

    participate(114, "参与组件玩法"),

    answer(115, "答题组件玩法"),

    tmrAward(116, "明日奖励组件玩法"),

    timing(117, "计时器组件玩法"),

    team(118, "队伍组件玩法"),

    collectAward(119, "收集条件出奖组件玩法"),

    keywordCheck(120, "关键词检查"),
    ;

    private int type;

    private String desc;

    PlaywayEnum(int type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public static PlaywayEnum toEnum(int type) {
        for (PlaywayEnum p : values()) {
            if (p.type == type) {
                return p;
            }
        }
        return null;
    }

    public int getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }

    public static String getDefaultRank() {
        return String.valueOf(SCORING.getType());
    }

    public static boolean isDefaultRank(String playwayId) {
        return StringUtils.equals(playwayId, getDefaultRank());
    }

    public static boolean isDefaultSign(String playwayId) {
        return StringUtils.equals(playwayId, String.valueOf(SIGN.getType()));
    }

    public static boolean isRank(String playwayType) {
        return StringUtils.equals(playwayType, rank.name());
    }

    public static boolean isAnswer(String playwayType) {
        return StringUtils.equals(playwayType, answer.name());
    }
    public static boolean isKeywordCheck(String playwayType) {
        return StringUtils.equals(playwayType, keywordCheck.name());
    }

}
