package cn.com.duiba.cloud.duiba.activity.service.api.remoteservice.playways.remote;


import cn.com.duiba.cloud.duiba.activity.service.api.dto.PlaywayRankingDTO;
import cn.com.duiba.cloud.duiba.activity.service.api.dto.RankingConfigDTO;
import cn.com.duiba.cloud.duiba.activity.service.api.remoteservice.playways.Ranking;

import java.util.List;

public interface RemoteRankingApi {
    /**
     * 更新排行榜分数
     *
     * @param score    分值
     * @param high2low true:从高到低  false:从低到高
     */
    void updateRankingScore(Long activityId, Long cid, String type, int score, boolean high2low);

    /**
     * 更新排行榜分数自动+1
     * 使用从高到低的排序
     */
    void updateRankingScoreByIncr(Long activityId, Long cid, String type);

    /**
     * 清零我的分数
     *
     * @param type
     */
    void clearRankingScore(Long activityId, Long cid, String type);

    /**
     * 查询我的排名，返回null表明在3000名开外
     *
     * @param type
     * @return
     */
    Integer getMyRank(Long activityId, Long cid, String type);


    /**
     * 查询我的排行榜信息
     *
     * @param type
     * @return
     */
    Ranking getMyRankInfo(Long activityId, Long cid, String type);


    /**
     * 更新另一个人的排行榜数据
     * <p>
     * 慎用，目前合理的一个使用方式是：在助力时，给助力发起方+1
     *
     * @param somebodyUserId
     * @param type
     */
    void updateSomebodyRankingScoreByIncr(Long activityId, Long somebodyUserId, String type);
    /**
     * 更新另一个人的排行榜数据
     * <p>
     * 慎用，目前合理的一个使用方式是：在助力时，给助力发起方+1
     *
     * @param somebodyUserId
     * @param type
     */
    void updateSomebodyRankingScoreByIncr(Long activityId, Long somebodyUserId, String type, int incr);

    void clearSomebodyRankingScore(Long activityId, Long somebodyUserId, String type);

    /**
     * 查询制定用户的排名，返回null表明在3000名开外
     *
     * @param type
     * @param sombodyUserId
     * @return
     */
    Integer getSomebodyRank(Long activityId, String type, Long sombodyUserId);

    /**
     * 查询制定用户的排行榜信息，返回null表明在3000名开外
     *
     * @param type
     * @param sombodyUserId
     * @return
     */
    PlaywayRankingDTO getSomebodyRankInfo(Long activityId, String type, Long sombodyUserId);

    /**
     * 导入排行榜配置数据
     *
     * @param type            类型
     * @param rankingName     排行榜名称
     * @param manualSendPrize 是否手动发奖
     */
    void insertRankingConfig(Long activityId, String type, String rankingName, Boolean manualSendPrize);

    /**
     * 根据类型获取排行榜信息 如果没有返回null
     *
     * @param type
     * @return
     */
    RankingConfigDTO getRankingConfigByType(Long activityId, String type);

    /**
     * 获取前几名的排行榜信息
     *
     * @param type 排行榜id
     * @param topN 前几名
     *             不允许调用超过1000名的排名，会有性能问题
     * @return ranking 列表
     */
    List<Ranking> getTopN(Long activityId, String type, int topN);

    /**
     * 将某个用户加入排行榜的黑名单
     *
     * @param somebodyUserId 要被风控的用户Id
     * @param type           排行榜期次
     * @return 返回是否将此人加入排行榜黑名单成功
     * 排行榜已经过期结束也会返回false，
     * 用户还未参与榜单也会返回false，
     * 重复标记用户也会返回false
     */
    Boolean invalidSomebodyScore(Long activityId, String type, Long somebodyUserId);

}
