package cn.com.duiba.cloud.duiba.activity.service.api.remoteservice.activity;

import cn.com.duiba.biz.tool.duiba.dto.page.Page;
import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.cloud.duiba.activity.service.api.dto.activity.ActivityDetailDTO;
import cn.com.duiba.cloud.duiba.activity.service.api.dto.activity.MallActivityDTO;
import cn.com.duiba.cloud.duiba.activity.service.api.param.ActivityAddRequest;

/**
 * @date:2022/3/24 11:50
 * @author:zhaozhanghai
 * @Description: 活动服务
 */
@AdvancedFeignClient
public interface RemoteActivityService {


    /**
     *
     *
     * @param request@return 活动id
     * @throws BizException
     */
    Long addActivityAndPrize(ActivityAddRequest request) throws BizException;


    /**
     * 修改活动和奖品
     *
     * @param request @return
     * @throws BizException
     * @return
     */
    Boolean updateActivityAndPrize(ActivityAddRequest request) throws BizException;

    MallActivityDTO getByActivityId(Long activityId);

    /**
     * 删除活动
     * @param activityId
     * @return
     */
    Boolean delete(Long activityId);

    /**
     * 更新活动状态
     * @param activityId
     * @param status
     * @return
     */
    Boolean updateStatus(Long activityId,Integer status);

    /**
     * 分页查询
     * @param page
     * @param dto
     * @return
     */
    Page<MallActivityDTO> page(Page page, MallActivityDTO dto);


    /**
     * 活动详情
     * @param activityId
     * @return
     * @throws BizException
     */
    ActivityDetailDTO detail(Long activityId) throws BizException;



}
