package cn.com.duiba.cloud.duiba.activity.service.api.jsonparse.base;

import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

/**
 * @date:2022/3/26 10:40
 * @author:zhaozhanghai
 * @Description: 概率出奖 奖品vo
 */
@Data
public class BasePrizeVo implements Serializable {

    /**
     * id
     */
    private Long id;

    /**
     * 活动id
     */
    private Long activityId;

    /**
     * 规则code
     */
    private String ruleCode;

    /**
     * 规则名
     */
    private String ruleName;


    /**
     * 奖品名
     */
    private String prizeName;

    /**
     * 奖项商品ID,type为2的时候为道具ID
     */
    private Long itemId;

    /**
     * 奖项商品ID
     */
    private Long skuId;

    /**
     * 中奖概率
     */
    private BigDecimal probability;

    /**
     * 概率类型：1，普通概率；2，替补必中
     */
    private Integer probabilityType;


    /**
     * 奖品图片
     */
    private String icon;

    /**
     * 总库存
     */
    private Integer totalStock;

    /**
     * 已使用库存
     */
    private Integer usedStock;

    /**
     *奖品规则：1商品，2道具 3谢谢参与
     */
    private Integer prizeType;

    /**
     * 奖励数量
     */
    private Integer amount;

    /**
     * 中奖限制次数 0-不开启 大于0-限制次数
     */
    private Integer winningLimitTimes;

    /**
     * 保底抽奖次数 0-不开启 大于0-保底次数
     */
    private Integer guaranteedLotteryTimes;

    /**
     * 奖品信息展示于玩法皮肤上 0-不展示，1-展示
     */
    private Integer showPrize;

    /**
     * 分层出奖扩展字段
     */
    private List<BasePrizeVipExtVo> prizeVipExtVo;



}
